/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterstructure.forge.events;

import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.starterstructure_common_forge.events.StructureCreationEvents;
import java.lang.invoke.MethodHandles;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class ForgeStructureCreationEvents {
    public static void registerEventsInBus() {
        BusGroup.DEFAULT.register(MethodHandles.lookup(), ForgeStructureCreationEvents.class);
    }

    @SubscribeEvent(priority=-127)
    public static boolean onLevelSpawn(LevelEvent.CreateSpawnPosition e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return false;
        }
        return StructureCreationEvents.onLevelSpawn((ServerLevel)level, (ServerLevelData)level.getLevelData()).equals((Object)InteractionResult.SUCCESS);
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        StructureCreationEvents.onLevelLoad((ServerLevel)level);
    }
}

