/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterstructure.forge.events;

import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.starterstructure_common_forge.events.StructureProtectionEvents;
import java.lang.invoke.MethodHandles;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.PistonEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class ForgeStructureProtectionEvents {
    public static void registerEventsInBus() {
        BusGroup.DEFAULT.register(MethodHandles.lookup(), ForgeStructureProtectionEvents.class);
    }

    @SubscribeEvent
    public static boolean onBlockBreak(BlockEvent.BreakEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return false;
        }
        return !StructureProtectionEvents.onBlockBreak(level, e.getPlayer(), e.getPos(), e.getState(), null);
    }

    @SubscribeEvent
    public static boolean onBlockPlace(BlockEvent.EntityPlaceEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return false;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        return !StructureProtectionEvents.onBlockPlace(level, e.getPos(), e.getPlacedBlock(), (LivingEntity)entity, null);
    }

    @SubscribeEvent
    public static boolean onPistonMove(PistonEvent.Pre e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return false;
        }
        return !StructureProtectionEvents.onPistonMove(level, e.getPos(), e.getDirection(), e.getPistonMoveType().isExtend());
    }

    @SubscribeEvent
    public static void onTNTExplode(ExplosionEvent.Detonate e) {
        StructureProtectionEvents.onTNTExplode(e.getLevel(), null, e.getExplosion());
    }
}

