/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterstructure_common_forge.events;

import com.natamus.collective_common_forge.functions.FeatureFunctions;
import com.natamus.collective_common_forge.functions.TaskFunctions;
import com.natamus.starterstructure_common_forge.config.ConfigHandler;
import com.natamus.starterstructure_common_forge.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;

public class StructureCreationEvents {
    public static InteractionResult onLevelSpawn(ServerLevel serverLevel, ServerLevelData serverLevelData) {
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)serverLevel.getServer(), () -> {
            if (ConfigHandler.shouldGenerateStructure) {
                BlockPos spawnPos = null;
                BlockPos structurePos = Util.generateSchematic(serverLevel);
                if (structurePos != null) {
                    spawnPos = structurePos.immutable();
                    if (ConfigHandler.shouldUseSpawnCoordOffsets) {
                        spawnPos = spawnPos.offset(ConfigHandler.spawnXCoordOffset, ConfigHandler.spawnYCoordOffset, ConfigHandler.spawnZCoordOffset).immutable();
                    }
                    LevelData.RespawnData oldRespawnData = serverLevel.getRespawnData();
                    LevelData.RespawnData newRespawnData = LevelData.RespawnData.of((ResourceKey)oldRespawnData.dimension(), (BlockPos)spawnPos, (float)oldRespawnData.yaw(), (float)oldRespawnData.pitch());
                    serverLevel.setRespawnData(newRespawnData);
                }
                if (spawnPos != null) {
                    try {
                        WorldOptions worldOptions = serverLevel.getServer().getWorldData().worldGenOptions();
                        if (worldOptions.generateBonusChest()) {
                            FeatureFunctions.placeBonusChest((Level)serverLevel, (BlockPos)spawnPos);
                        }
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                }
            }
        }, (int)1);
        if (ConfigHandler.shouldUseSpawnCoordinates || ConfigHandler.shouldUseSpawnCoordOffsets || ConfigHandler.shouldUseStructureOffset) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void onLevelLoad(ServerLevel serverLevel) {
        Util.readProtectedList(serverLevel);
    }
}

