/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud;

import com.mojang.blaze3d.platform.cursor.CursorTypes;
import dev.boxadactle.boxhud.BoxWidgets;
import dev.boxadactle.boxhud.Boxhud;
import dev.boxadactle.boxhud.PositionModifiers;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.util.ModUtil;
import dev.boxadactle.boxlib.math.geometry.Dimension;
import dev.boxadactle.boxlib.math.geometry.Rect;
import dev.boxadactle.boxlib.math.geometry.Vec2;
import dev.boxadactle.boxlib.math.mathutils.Clamps;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public class WidgetPositionScreen
extends Screen {
    Screen lastScreen;
    List<WidgetRenderer> widgets;

    public WidgetPositionScreen(Screen parent) {
        super((Component)Component.translatable((String)"boxhud.gui.widgetconfig.title"));
        this.lastScreen = parent;
    }

    protected void init() {
        this.widgets = new ArrayList<WidgetRenderer>();
        for (String id : BoxWidgets.widgetConfigs.keySet()) {
            WidgetEntry<?> entry = BoxWidgets.widgetConfigs.get(id);
            if (!entry.enabled) continue;
            this.widgets.add(new WidgetRenderer(id, entry));
        }
    }

    public void refresh() {
        this.widgets.clear();
        for (String id : BoxWidgets.widgetConfigs.keySet()) {
            WidgetEntry<?> entry = BoxWidgets.widgetConfigs.get(id);
            if (!entry.enabled) continue;
            this.widgets.add(new WidgetRenderer(id, entry));
        }
    }

    public void tick() {
        this.widgets.forEach(WidgetRenderer::tick);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        RenderUtils.drawSquare((GuiGraphics)guiGraphics, (int)0, (int)0, (int)this.width, (int)this.height, (int)-1877271524);
        super.render(guiGraphics, i, j, f);
        RenderUtils.drawTextCentered((GuiGraphics)guiGraphics, (Component)Component.translatable((String)"boxhud.gui.widgetconfig.doubleClick"), (int)(this.width / 2), (int)5);
        this.widgets.forEach(widget -> widget.render(guiGraphics, i, j));
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        for (WidgetRenderer w : this.widgets) {
            if (!w.onClick((int)event.x(), (int)event.y())) continue;
            return true;
        }
        return super.mouseClicked(event, isDoubleClick);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        for (WidgetRenderer w : this.widgets) {
            if (!w.onRelease()) continue;
            return true;
        }
        return super.mouseReleased(event);
    }

    public void onClose() {
        BoxWidgets.saveConfig(Boxhud.widgetConfigFile);
        Boxhud.CONFIG.save();
        ClientUtils.setScreen((Screen)this.lastScreen);
    }

    class WidgetRenderer {
        String id;
        WidgetEntry<?> entry;
        boolean clickBl = false;
        boolean isDragging = false;
        boolean isScaling = false;
        int dx = 0;
        int dy = 0;
        int scaleSize = 8;
        Rect<Integer> bounds;
        int clickDelta = 0;

        WidgetRenderer(String id, WidgetEntry<?> entry) {
            this.id = id;
            this.entry = entry;
            this.bounds = entry.preRender(true).calculateRect();
        }

        public PositionModifiers getClosestMod(Rect<Integer> bounds) {
            PositionModifiers mod = this.entry.widget.getDefaultModifier();
            Dimension<Integer> dim = ModUtil.getWindowSize(this.entry.scale);
            for (PositionModifiers m : PositionModifiers.values()) {
                Vec2<Integer> mstart = m.mod.getStartCorner(bounds);
                Vec2<Integer> mzero = m.mod.translateVector((Vec2<Integer>)new Vec2((Number)0, (Number)0), dim);
                Vec2<Integer> start = mod.mod.getStartCorner(bounds);
                Vec2<Integer> zero = mod.mod.translateVector((Vec2<Integer>)new Vec2((Number)0, (Number)0), dim);
                if (!(ModUtil.calculatePointDistance(mstart, mzero) < ModUtil.calculatePointDistance(start, zero))) continue;
                mod = m;
            }
            return mod;
        }

        public boolean onClick(int mouseX, int mouseY) {
            Vec2 mouse = new Vec2((Number)Math.round((float)mouseX / this.entry.scale), (Number)Math.round((float)mouseY / this.entry.scale));
            if (this.bounds.containsPoint(mouse)) {
                this.clickBl = true;
                if (this.calcScaleButton().containsPoint(mouse)) {
                    this.isScaling = true;
                    this.dx = Math.round((float)((Integer)this.bounds.getX()).intValue() * this.entry.scale);
                    this.dy = Math.round((float)((Integer)this.bounds.getY()).intValue() * this.entry.scale);
                } else if (this.entry.widget.allowMove()) {
                    this.isDragging = true;
                    this.dx = (Integer)mouse.getX() - (Integer)this.bounds.getX();
                    this.dy = (Integer)mouse.getY() - (Integer)this.bounds.getY();
                }
                return true;
            }
            return false;
        }

        public boolean onRelease() {
            if (this.clickBl) {
                BoxWidgets.widgetConfigs.put(this.id, this.entry);
                this.clickBl = false;
                this.isDragging = false;
                this.isScaling = false;
                if (this.clickDelta < 5) {
                    ClientUtils.setScreen((Screen)this.entry.widget.getConfigScreen(WidgetPositionScreen.this, this.entry));
                }
                this.clickDelta = 0;
                return true;
            }
            return false;
        }

        public void tick() {
            ++this.clickDelta;
        }

        public float calculateScale(int x, int y, int mouseX, int mouseY) {
            float rectSize = ModUtil.calculatePointDistance(x, y, x + (Integer)this.bounds.getWidth(), y + (Integer)this.bounds.getHeight());
            float mouseSize = ModUtil.calculatePointDistance(x, y, mouseX, mouseY);
            float scaleFactor = mouseSize / rectSize;
            scaleFactor = (float)Math.round(scaleFactor * 100.0f) / 100.0f;
            scaleFactor = Clamps.clamp((float)scaleFactor, (float)0.7f, (float)2.0f);
            return scaleFactor;
        }

        private void moveHud(int mouseX, int mouseY) {
            if (!this.clickBl) {
                return;
            }
            Vec2 mouse = new Vec2((Number)Math.round((float)mouseX / this.entry.scale), (Number)Math.round((float)mouseY / this.entry.scale));
            if (this.isDragging) {
                int x = (Integer)mouse.getX() - this.dx;
                int y = (Integer)mouse.getY() - this.dy;
                Rect clamped = Clamps.clampRect((int)x, (int)y, (int)((Integer)this.bounds.getWidth()), (int)((Integer)this.bounds.getHeight()), (int)0, (int)0, (int)Math.round((float)WidgetPositionScreen.this.width / this.entry.scale), (int)Math.round((float)WidgetPositionScreen.this.height / this.entry.scale));
                PositionModifiers mod = this.getClosestMod((Rect<Integer>)clamped);
                Vec2<Integer> transl = mod.mod.getRelativePos((Rect<Integer>)clamped, ModUtil.getWindowSize(this.entry.scale));
                this.entry.x = (Integer)transl.getX();
                this.entry.y = (Integer)transl.getY();
                this.entry.modifier = mod;
            } else if (this.isScaling) {
                this.entry.scale = this.calculateScale(this.dx, this.dy, mouseX, mouseY);
                if (this.entry.widget.allowMove()) {
                    this.bounds.setX((Number)((int)((float)this.dx / this.entry.scale)));
                    this.bounds.setY((Number)((int)((float)this.dy / this.entry.scale)));
                    Vec2<Integer> transl = this.entry.modifier.mod.getRelativePos(this.bounds, ModUtil.getWindowSize(this.entry.scale));
                    this.entry.x = (Integer)transl.getX();
                    this.entry.y = (Integer)transl.getY();
                }
            }
        }

        private Rect<Integer> calcScaleButton() {
            return new Rect((Number)(this.bounds.getMaxX() - this.scaleSize), (Number)(this.bounds.getMaxY() - this.scaleSize), (Number)this.scaleSize, (Number)this.scaleSize);
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (!this.clickBl && this.bounds.containsPoint(new Vec2((Number)mouseX, (Number)mouseY))) {
                if (this.calcScaleButton().containsPoint(new Vec2((Number)mouseX, (Number)mouseY))) {
                    guiGraphics.requestCursor(CursorTypes.RESIZE_ALL);
                } else {
                    guiGraphics.requestCursor(CursorTypes.CROSSHAIR);
                }
            }
            Vec2 mouse = new Vec2((Number)Math.round((float)mouseX / this.entry.scale), (Number)Math.round((float)mouseY / this.entry.scale));
            boolean bl = this.bounds.containsPoint(mouse);
            this.moveHud(mouseX, mouseY);
            if (!bl) {
                guiGraphics.pose().pushMatrix();
                guiGraphics.pose().scale(this.entry.scale, this.entry.scale);
                RenderUtils.drawSquare((GuiGraphics)guiGraphics, this.bounds, (int)-2145444065);
                int color = -2063597568;
                int x = (Integer)this.bounds.getX();
                int y = (Integer)this.bounds.getY();
                int width = (Integer)this.bounds.getWidth();
                int height = (Integer)this.bounds.getHeight();
                guiGraphics.fill(x, y, x + width, y + 2, color);
                guiGraphics.fill(x, y + height - 2, x + width, y + height, color);
                guiGraphics.fill(x, y + 2, x + 2, y + height - 2, color);
                guiGraphics.fill(x + width - 2, y + 2, x + width, y + height - 2, color);
                guiGraphics.pose().popMatrix();
            }
            boolean bl2 = this.entry.renderBackground;
            this.entry.renderBackground = false;
            this.bounds = this.entry.renderPlaceholder(guiGraphics);
            this.entry.renderBackground = bl2;
            if (bl) {
                int color = 1355270087;
                int scaleColor = -1713766406;
                guiGraphics.pose().pushMatrix();
                guiGraphics.pose().scale(this.entry.scale, this.entry.scale);
                RenderUtils.drawSquare((GuiGraphics)guiGraphics, this.bounds, (int)color);
                RenderUtils.drawSquare((GuiGraphics)guiGraphics, this.calcScaleButton(), (int)scaleColor);
                guiGraphics.pose().popMatrix();
            }
            if (this.isDragging) {
                Vec2<Integer> pos = this.entry.modifier.mod.translateVector((Vec2<Integer>)new Vec2((Number)0, (Number)0), ModUtil.getWindowSize(this.entry.scale));
                RenderUtils.drawSquare((GuiGraphics)guiGraphics, (int)((int)(this.entry.scale * (float)((Integer)pos.getX()).intValue() - 5.0f)), (int)((int)(this.entry.scale * (float)((Integer)pos.getY()).intValue() - 5.0f)), (int)10, (int)10, (int)-1711341568);
            }
        }
    }
}

