/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.util;

import java.util.LinkedList;

public class ClickTracker {
    private static final LinkedList<Long> leftClickTimestamps = new LinkedList();
    private static final LinkedList<Long> rightClickTimestamps = new LinkedList();
    private static final long TIME_WINDOW_MS = 1000L;

    public static void clickLeft() {
        long currentTime = System.currentTimeMillis();
        leftClickTimestamps.add(currentTime);
        ClickTracker.removeOldTimestamps(leftClickTimestamps, currentTime);
    }

    public static void clickRight() {
        long currentTime = System.currentTimeMillis();
        rightClickTimestamps.add(currentTime);
        ClickTracker.removeOldTimestamps(rightClickTimestamps, currentTime);
    }

    public static int getLeftCPS() {
        long currentTime = System.currentTimeMillis();
        ClickTracker.removeOldTimestamps(leftClickTimestamps, currentTime);
        return leftClickTimestamps.size();
    }

    public static int getRightCPS() {
        long currentTime = System.currentTimeMillis();
        ClickTracker.removeOldTimestamps(rightClickTimestamps, currentTime);
        return rightClickTimestamps.size();
    }

    private static void removeOldTimestamps(LinkedList<Long> timestamps, long currentTime) {
        while (!timestamps.isEmpty() && currentTime - timestamps.getFirst() > 1000L) {
            timestamps.removeFirst();
        }
    }
}

