/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.widget.general;

import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import dev.boxadactle.boxhud.Boxhud;
import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.util.ModUtil;
import dev.boxadactle.boxhud.widget.Widgets;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.widget.slider.BIntegerSlider;
import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.LayoutContainerComponent;
import dev.boxadactle.boxlib.layouts.component.TextComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.boxlib.util.ClientUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.IoSupplier;

public class ResourcePackWidget
implements Widgets.General {
    static HashMap<String, ResourceLocation> packIcons = new HashMap();
    public int textPadding = 4;

    @Override
    public String getNameKey() {
        return "resourcepack";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ResourceLocation getPackIcon(Pack resourcepack) {
        if (packIcons.containsKey(resourcepack.getId())) {
            return packIcons.get(resourcepack.getId());
        }
        ResourceLocation unknownPackIcon = ResourceLocation.withDefaultNamespace((String)"textures/misc/unknown_pack.png");
        try (PackResources packresources = resourcepack.open();){
            ResourceLocation resourceLocation;
            block17: {
                IoSupplier iosupplier = packresources.getRootResource(new String[]{"pack.png"});
                if (iosupplier == null) {
                    Boxhud.LOGGER.warn((Object)("Resource pack " + resourcepack.getId() + " does not have a pack.png"), new Object[0]);
                    packIcons.put(resourcepack.getId(), unknownPackIcon);
                    ResourceLocation resourceLocation2 = unknownPackIcon;
                    return resourceLocation2;
                }
                String s = resourcepack.getId();
                String var10003 = Util.sanitizeName((String)s, ResourceLocation::validPathChar);
                ResourceLocation resourcelocation = ResourceLocation.withDefaultNamespace((String)("pack/" + var10003 + "/" + String.valueOf(Hashing.sha256().hashUnencodedChars((CharSequence)s)) + "/icon"));
                InputStream inputstream = (InputStream)iosupplier.get();
                try {
                    NativeImage nativeimage = NativeImage.read((InputStream)inputstream);
                    ClientUtils.getClient().getTextureManager().register(resourcelocation, (AbstractTexture)new DynamicTexture(() -> ((ResourceLocation)resourcelocation).toString(), nativeimage));
                    packIcons.put(resourcepack.getId(), resourcelocation);
                    resourceLocation = resourcelocation;
                    if (inputstream == null) break block17;
                }
                catch (Throwable throwable) {
                    if (inputstream != null) {
                        try {
                            inputstream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputstream.close();
            }
            return resourceLocation;
        }
        catch (Exception e) {
            Boxhud.LOGGER.warn((Object)("Failed to open resource pack: " + resourcepack.getId()), new Object[]{e});
            Boxhud.LOGGER.printStackTrace(e);
            packIcons.put(resourcepack.getId(), unknownPackIcon);
            return unknownPackIcon;
        }
    }

    @Override
    public RenderingLayout createWidget(int x, int y) {
        ColumnLayout columnLayout = new ColumnLayout(0, 0, this.textPadding);
        columnLayout.addComponent((LayoutComponent)new TextComponent(this.definition("text", new Object[0])));
        PackRepository repo = ClientUtils.getClient().getResourcePackRepository();
        ArrayList<Pack> selected = new ArrayList<Pack>(repo.getSelectedPacks());
        selected.removeIf(ModUtil::shouldExcludePack);
        for (final Pack pack : selected) {
            if (selected.size() > 1 && pack.getId().equalsIgnoreCase("vanilla")) continue;
            RowLayout rowLayout = new RowLayout(0, 0, this.textPadding);
            rowLayout.addComponent((LayoutComponent)new LayoutComponent<Object>(null){

                public int getWidth() {
                    return 16;
                }

                public int getHeight() {
                    return 16;
                }

                public void render(GuiGraphics guiGraphics, int i, int i1) {
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ResourcePackWidget.this.getPackIcon(pack), i, i1, 0.0f, 0.0f, 16, 16, 16, 16);
                }
            });
            rowLayout.addComponent((LayoutComponent)new TextComponent(pack.getTitle()));
            columnLayout.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)rowLayout));
        }
        return new PaddingLayout(x, y, this.padding(), (RenderingLayout)columnLayout);
    }

    @Override
    public HudWidget.ConfigFactory<?> getConfigFactory() {
        return new HudWidget.ConfigFactory<ResourcePackWidget>(this){

            @Override
            protected void addCustomConfigEntries(WidgetEntry<ResourcePackWidget> entry, Consumer<BOptionEntry<?>> consumer) {
                consumer.accept((BOptionEntry<?>)new BIntegerSlider("boxhud.gui.widget.textPadding", 1, 10, ((ResourcePackWidget)entry.widget).textPadding, v -> {
                    ((ResourcePackWidget)entry.widget).textPadding = v;
                }));
            }
        };
    }

    @Override
    public int getDefaultX() {
        return 300;
    }

    @Override
    public int getDefaultY() {
        return 100;
    }

    @Override
    public boolean defaultEnabled() {
        return false;
    }
}

