/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.widget.pvp;

import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.PositionModifiers;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.widget.Widgets;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.gui.config.widget.slider.BIntegerSlider;
import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.WorldUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ArmorWidget
implements Widgets.Pvp {
    public boolean isColumn = true;
    public int innerPadding = 1;

    @Override
    public String getNameKey() {
        return "armor";
    }

    private RenderingLayout create(List<ItemStack> items) {
        ColumnLayout base = this.isColumn ? new ColumnLayout(0, 0, this.innerPadding) : new RowLayout(0, 0, this.innerPadding);
        for (final ItemStack item : items.reversed()) {
            if (item.isEmpty()) continue;
            base.addComponent((LayoutComponent)new LayoutComponent<Object>(this, null){

                public int getWidth() {
                    return 16;
                }

                public int getHeight() {
                    return 16;
                }

                public void render(GuiGraphics guiGraphics, int i, int i1) {
                    guiGraphics.renderItem(item, i, i1);
                    guiGraphics.renderItemDecorations(GuiUtils.getTextRenderer(), item, i, i1);
                }
            });
        }
        return base;
    }

    @Override
    public RenderingLayout createWidget(int x, int y) {
        Inventory inventory = WorldUtils.getPlayer().getInventory();
        return new PaddingLayout(x, y, this.padding(), this.create(List.of(inventory.getItem(36), inventory.getItem(37), inventory.getItem(38), inventory.getItem(39))));
    }

    @Override
    public RenderingLayout createPlaceholderWidget(int x, int y) {
        return new PaddingLayout(x, y, this.padding(), this.create(List.of(new ItemStack((ItemLike)Items.NETHERITE_BOOTS), new ItemStack((ItemLike)Items.IRON_LEGGINGS), new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE), new ItemStack((ItemLike)Items.LEATHER_HELMET))));
    }

    @Override
    public HudWidget.ConfigFactory<?> getConfigFactory() {
        return new HudWidget.ConfigFactory<ArmorWidget>(this){

            @Override
            protected void addCustomConfigEntries(WidgetEntry<ArmorWidget> entry, Consumer<BOptionEntry<?>> consumer) {
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.armor.orientation", Boolean.valueOf(((ArmorWidget)entry.widget).isColumn), value -> {
                    ((ArmorWidget)entry.widget).isColumn = value;
                }));
                consumer.accept((BOptionEntry<?>)new BIntegerSlider("boxhud.widget.armor.innerPadding", 0, 5, ((ArmorWidget)entry.widget).innerPadding, value -> {
                    ((ArmorWidget)entry.widget).innerPadding = value;
                }));
            }
        };
    }

    @Override
    public int getDefaultX() {
        return 0;
    }

    @Override
    public int getDefaultY() {
        return 10;
    }

    @Override
    public boolean defaultEnabled() {
        return false;
    }

    @Override
    public PositionModifiers getDefaultModifier() {
        return PositionModifiers.BOTTOM_LEFT;
    }

    @Override
    public boolean defaultRenderBackground() {
        return false;
    }
}

