/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.widget.pvp;

import com.google.common.collect.Lists;
import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.PositionModifiers;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.widget.Widgets;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.gui.config.widget.slider.BIntegerSlider;
import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.LayoutContainerComponent;
import dev.boxadactle.boxlib.layouts.component.TextComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.boxlib.util.WorldUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;

public class PotionsWidget
implements Widgets.Pvp {
    int padding = 2;
    boolean renderNames = true;

    @Override
    public String getNameKey() {
        return "potions";
    }

    private Component getEffectName(MobEffectInstance mobEffectInstance) {
        MutableComponent mutableComponent = ((MobEffect)mobEffectInstance.getEffect().value()).getDisplayName().copy();
        if (mobEffectInstance.getAmplifier() >= 1 && mobEffectInstance.getAmplifier() <= 9) {
            MutableComponent var10000 = mutableComponent.append(CommonComponents.SPACE);
            int var10001 = mobEffectInstance.getAmplifier();
            var10000.append((Component)Component.translatable((String)("enchantment.level." + (var10001 + 1))));
        }
        return mutableComponent;
    }

    private RenderingLayout create(Collection<MobEffectInstance> effects, boolean bl) {
        ColumnLayout columnLayout = new ColumnLayout(0, 0, this.padding);
        if (effects.isEmpty()) {
            columnLayout.addComponent((LayoutComponent)new TextComponent(this.definition("empty", new Object[0])));
            return columnLayout;
        }
        for (final MobEffectInstance effect : effects) {
            RowLayout layout = new RowLayout(0, 0, this.padding);
            layout.addComponent((LayoutComponent)new LayoutComponent<Object>(null){

                public int getWidth() {
                    return PotionsWidget.this.renderNames ? 24 : 16;
                }

                public int getHeight() {
                    return PotionsWidget.this.renderNames ? 24 : 16;
                }

                public void render(GuiGraphics guiGraphics, int i, int i1) {
                    Holder holder = effect.getEffect();
                    guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, Gui.getMobEffectSprite((Holder)holder), i, i1, this.getWidth(), this.getHeight());
                }
            });
            ColumnLayout layout1 = new ColumnLayout(0, 0, this.padding);
            if (this.renderNames) {
                layout1.addComponent((LayoutComponent)new TextComponent(this.getEffectName(effect)));
            } else {
                layout1.addComponent((LayoutComponent)new LayoutComponent<Object>(this, null){

                    public int getWidth() {
                        return 0;
                    }

                    public int getHeight() {
                        return 1;
                    }

                    public void render(GuiGraphics guiGraphics, int i, int i1) {
                    }
                });
            }
            layout1.addComponent((LayoutComponent)new TextComponent(MobEffectUtil.formatDuration((MobEffectInstance)effect, (float)1.0f, (float)(bl ? 20.0f : WorldUtils.getWorld().tickRateManager().tickrate()))));
            layout.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)layout1));
            columnLayout.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)layout));
        }
        return columnLayout;
    }

    @Override
    public RenderingLayout createWidget(int x, int y) {
        Collection collection = WorldUtils.getPlayer().getActiveEffects();
        return new PaddingLayout(x, y, this.padding(), this.create(collection, false));
    }

    @Override
    public RenderingLayout createPlaceholderWidget(int x, int y) {
        ArrayList collection = Lists.newArrayList((Object[])new MobEffectInstance[]{new MobEffectInstance(MobEffects.BLINDNESS, 100, 1), new MobEffectInstance(MobEffects.NIGHT_VISION, 200, 5), new MobEffectInstance(MobEffects.POISON, 300, 10)});
        return new PaddingLayout(x, y, this.padding(), this.create(collection, true));
    }

    @Override
    public HudWidget.ConfigFactory<?> getConfigFactory() {
        return new HudWidget.ConfigFactory<PotionsWidget>(this){

            @Override
            protected void addCustomConfigEntries(WidgetEntry<PotionsWidget> entry, Consumer<BOptionEntry<?>> consumer) {
                consumer.accept((BOptionEntry<?>)new BIntegerSlider("boxhud.widget.potions.padding", 0, 10, ((PotionsWidget)entry.widget).padding, value -> {
                    ((PotionsWidget)entry.widget).padding = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.potions.renderNames", Boolean.valueOf(((PotionsWidget)entry.widget).renderNames), value -> {
                    ((PotionsWidget)entry.widget).renderNames = value;
                }));
            }
        };
    }

    @Override
    public int getDefaultX() {
        return 0;
    }

    @Override
    public int getDefaultY() {
        return 0;
    }

    @Override
    public boolean defaultEnabled() {
        return false;
    }

    @Override
    public PositionModifiers getDefaultModifier() {
        return PositionModifiers.TOP_RIGHT;
    }
}

