/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.widget.system;

import dev.boxadactle.boxhud.BoxWidgets;
import dev.boxadactle.boxhud.Boxhud;
import dev.boxadactle.boxhud.CoordinatesDisplayWrapper;
import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.util.ModUtil;
import dev.boxadactle.boxhud.widget.Widgets;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.gui.config.widget.slider.BIntegerSlider;
import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.LayoutContainerComponent;
import dev.boxadactle.boxlib.layouts.component.LeftParagraphComponent;
import dev.boxadactle.boxlib.layouts.component.ParagraphComponent;
import dev.boxadactle.boxlib.layouts.component.TextComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.boxlib.util.WorldUtils;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;

public class CoordinatesWidget
implements Widgets.System {
    public int textPadding = 5;
    public boolean renderDirection = true;
    public boolean renderBiome = true;

    private Component[] createDirectionComponents(double yaw) {
        String[][] directions = new String[][]{{" ", "+"}, {"-", "+"}, {"-", " "}, {"-", "-"}, {" ", "-"}, {"+", "-"}, {"+", " "}, {"+", "+"}};
        String[] direction = directions[(int)Math.round(yaw / 45.0) & 7];
        return new Component[]{Component.literal((String)direction[0]), this.translation(ModUtil.getDirectionFromYaw(yaw), new Object[0]), Component.literal((String)direction[1])};
    }

    @Override
    public void tick() {
        if (Boxhud.cdInstalled) {
            Boxhud.optDep(() -> {
                BoxWidgets.getWidgetEntry((String)"coordinates").renderBackground = CoordinatesDisplayWrapper.getBackgroundEnabled();
            });
        }
    }

    @Override
    public String getNameKey() {
        return "coords";
    }

    private RenderingLayout create(int x, int y, int z, Component biome, double yaw) {
        RowLayout layout = new RowLayout(0, 0, this.textPadding);
        ColumnLayout row = new ColumnLayout(0, 0, this.textPadding / 2);
        Component xtext = this.definition("x", this.value(Integer.toString(x)));
        Component ytext = this.definition("y", this.value(Integer.toString(y)));
        Component ztext = this.definition("y", this.value(Integer.toString(z)));
        ParagraphComponent paragraph = new ParagraphComponent(1, new Component[]{xtext, ytext, ztext});
        row.addComponent((LayoutComponent)paragraph);
        if (this.renderBiome) {
            row.addComponent((LayoutComponent)new TextComponent(biome));
        }
        layout.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)row));
        if (this.renderDirection) {
            Component[] directionTexts = this.createDirectionComponents(yaw);
            Component xDirection = this.definition(directionTexts[0]);
            Component directionText = this.value(directionTexts[1]);
            Component zDirection = this.definition(directionTexts[2]);
            layout.addComponent((LayoutComponent)new LeftParagraphComponent(1, new Component[]{xDirection, directionText, zDirection}));
        }
        return layout;
    }

    private ResourceLocation getBiomeKey(Holder<Biome> b) {
        ResourceLocation def = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"plains");
        if (b == null) {
            return def;
        }
        return (ResourceLocation)b.unwrap().map(ResourceKey::location, biome -> def);
    }

    @Override
    public RenderingLayout createWidget(int x, int y) {
        ColumnLayout layout;
        if (Boxhud.cdInstalled) {
            layout = new AtomicReference(Optional.empty());
            Boxhud.optDep(() -> layout.set(CoordinatesDisplayWrapper.executePrerender(WorldUtils.getPlayer(), x, y)));
            if (((Optional)layout.get()).isPresent()) {
                return (RenderingLayout)((Optional)layout.get()).get();
            }
            Boxhud.LOGGER.error((Object)"Failed to get CoordinatesDisplay prerender, using default.", new Object[0]);
        }
        if (WorldUtils.getWorld() == null) {
            layout = new ColumnLayout(0, 0, 0);
            layout.addComponent((LayoutComponent)new TextComponent(this.definition("error", new Object[0])));
            return new PaddingLayout(x, y, this.padding(), (RenderingLayout)layout);
        }
        Player player = WorldUtils.getPlayer();
        BlockPos b = new BlockPos(player.getBlockX(), player.getBlockY(), player.getBlockZ());
        Holder biome = WorldUtils.getWorld().getBiome(b);
        ResourceLocation location = this.getBiomeKey((Holder<Biome>)biome);
        float yaw = Mth.wrapDegrees((float)player.getYRot());
        return new PaddingLayout(x, y, this.padding(), this.create(b.getX(), b.getY(), b.getZ(), ModUtil.getBiomeComponent(location, (Biome)biome.value()), yaw));
    }

    @Override
    public RenderingLayout createPlaceholderWidget(int x, int y) {
        if (Boxhud.cdInstalled) {
            AtomicReference layout = new AtomicReference(Optional.empty());
            Boxhud.optDep(() -> layout.set(CoordinatesDisplayWrapper.executePrerender(null, x, y)));
            if (layout.get().isPresent()) {
                return (RenderingLayout)layout.get().get();
            }
            Boxhud.LOGGER.error((Object)"Failed to get CoordinatesDisplay prerender, using default.", new Object[0]);
        }
        return new PaddingLayout(x, y, this.padding(), this.create(302, -32, 1932, (Component)Component.literal((String)"Plains"), 183.0));
    }

    @Override
    public Screen getConfigScreen(Screen parent, WidgetEntry<?> entry) {
        if (Boxhud.cdInstalled) {
            AtomicReference s = new AtomicReference();
            Boxhud.optDep(() -> s.set(CoordinatesDisplayWrapper.getConfigScreen(parent)));
            if (s.get() != null) {
                return (Screen)s.get();
            }
            Boxhud.LOGGER.error((Object)"Failed to get CoordinatesDisplay config screen, using default.", new Object[0]);
        }
        return Widgets.System.super.getConfigScreen(parent, entry);
    }

    @Override
    public HudWidget.ConfigFactory<?> getConfigFactory() {
        return new HudWidget.ConfigFactory<CoordinatesWidget>(this){

            @Override
            protected void addCustomConfigEntries(WidgetEntry<CoordinatesWidget> entry, Consumer<BOptionEntry<?>> consumer) {
                consumer.accept((BOptionEntry<?>)new BIntegerSlider("boxhud.gui.widget.textPadding", 1, 10, ((CoordinatesWidget)entry.widget).textPadding, value -> {
                    ((CoordinatesWidget)entry.widget).textPadding = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.coords.renderBiome", Boolean.valueOf(((CoordinatesWidget)entry.widget).renderBiome), value -> {
                    ((CoordinatesWidget)entry.widget).renderBiome = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.coords.renderDirection", Boolean.valueOf(((CoordinatesWidget)entry.widget).renderDirection), value -> {
                    ((CoordinatesWidget)entry.widget).renderDirection = value;
                }));
            }
        };
    }

    @Override
    public int getDefaultX() {
        return 5;
    }

    @Override
    public int getDefaultY() {
        return 5;
    }

    @Override
    public boolean defaultEnabled() {
        return false;
    }
}

