/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.widget.system;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.PositionModifiers;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.util.ModUtil;
import dev.boxadactle.boxhud.widget.Widgets;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.gui.config.widget.field.BArgbField;
import dev.boxadactle.boxlib.gui.config.widget.label.BCenteredLabel;
import dev.boxadactle.boxlib.gui.config.widget.slider.BIntegerSlider;
import dev.boxadactle.boxlib.keybind.KeybindHelper;
import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.LayoutContainerComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.RenderUtils;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class KeystrokeWidget
implements Widgets.System,
HudWidget {
    public int innerPadding = 1;
    public int upColor = 1883917391;
    public int downColor = 1893392616;
    public boolean useKeybinds = true;
    public boolean displaySpacebarText = true;

    @Override
    public String getNameKey() {
        return "keystroke";
    }

    @Override
    public RenderingLayout createWidget(int x, int y) {
        ColumnLayout layout = new ColumnLayout(x, y, this.innerPadding);
        Options options = ClientUtils.getOptions();
        RowLayout row1 = new RowLayout(0, 0, this.innerPadding);
        row1.addComponent((LayoutComponent)new Keystroke(-1, null, null));
        row1.addComponent((LayoutComponent)new Keystroke(3, options.keyUp, "W"));
        layout.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)row1));
        final RowLayout row2 = new RowLayout(0, 0, this.innerPadding);
        row2.addComponent((LayoutComponent)new Keystroke(3, options.keyLeft, "A"));
        row2.addComponent((LayoutComponent)new Keystroke(3, options.keyDown, "S"));
        row2.addComponent((LayoutComponent)new Keystroke(3, options.keyRight, "D"));
        layout.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)row2));
        RowLayout row3 = new RowLayout(0, 0, this.innerPadding);
        row3.addComponent((LayoutComponent)new Keystroke(2, options.keyAttack, "LMB", true));
        row3.addComponent((LayoutComponent)new Keystroke(2, options.keyUse, "RMB", true));
        layout.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)row3));
        final InputConstants.Key jump = KeybindHelper.getBoundKey((KeyMapping)options.keyJump);
        layout.addComponent((LayoutComponent)new LayoutComponent<Object>(null){

            public int getWidth() {
                return (Integer)row2.calculateRect().getWidth();
            }

            public int getHeight() {
                return 9;
            }

            public void render(GuiGraphics guiGraphics, int i, int i1) {
                int color = jump.getValue() != -1 && InputConstants.isKeyDown((Window)ClientUtils.getClient().getWindow(), (int)jump.getValue()) ? KeystrokeWidget.this.downColor : KeystrokeWidget.this.upColor;
                RenderUtils.drawSquare((GuiGraphics)guiGraphics, (int)i, (int)i1, (int)this.getWidth(), (int)9, (int)color);
                if (KeystrokeWidget.this.displaySpacebarText) {
                    RenderUtils.drawTextCentered((GuiGraphics)guiGraphics, (String)"-----", (int)(i + 24), (int)i1);
                }
            }
        });
        return layout;
    }

    @Override
    public int getDefaultX() {
        return 0;
    }

    @Override
    public int getDefaultY() {
        return 20;
    }

    @Override
    public boolean defaultEnabled() {
        return false;
    }

    @Override
    public PositionModifiers getDefaultModifier() {
        return PositionModifiers.TOP_RIGHT;
    }

    public HudWidget.ConfigFactory<KeystrokeWidget> getConfigFactory() {
        return new HudWidget.ConfigFactory<KeystrokeWidget>(this){

            @Override
            protected void addCustomConfigEntries(WidgetEntry<KeystrokeWidget> entry, Consumer<BOptionEntry<?>> consumer) {
                consumer.accept((BOptionEntry<?>)new BIntegerSlider("boxhud.widget.keystroke.innerPadding", 0, 3, ((KeystrokeWidget)entry.widget).innerPadding, value -> {
                    ((KeystrokeWidget)entry.widget).innerPadding = value;
                }));
                consumer.accept((BOptionEntry<?>)new BCenteredLabel((Component)Component.translatable((String)"boxhud.widget.keystroke.upColor")));
                consumer.accept((BOptionEntry<?>)new BArgbField(Integer.valueOf(((KeystrokeWidget)entry.widget).upColor), c -> {
                    ((KeystrokeWidget)entry.widget).upColor = c;
                }));
                consumer.accept((BOptionEntry<?>)new BCenteredLabel((Component)Component.translatable((String)"boxhud.widget.keystroke.downColor")));
                consumer.accept((BOptionEntry<?>)new BArgbField(Integer.valueOf(((KeystrokeWidget)entry.widget).downColor), c -> {
                    ((KeystrokeWidget)entry.widget).downColor = c;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.keystroke.useKeybinds", Boolean.valueOf(((KeystrokeWidget)entry.widget).useKeybinds), value -> {
                    ((KeystrokeWidget)entry.widget).useKeybinds = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.keystroke.showTextOnSpacebar", Boolean.valueOf(((KeystrokeWidget)entry.widget).displaySpacebarText), value -> {
                    ((KeystrokeWidget)entry.widget).displaySpacebarText = value;
                }));
            }
        };
    }

    public class Keystroke
    extends LayoutComponent<Object> {
        int width;
        int height;
        InputConstants.Key key;
        String overrideName;
        boolean toggle;
        boolean useKeybinds;
        boolean isMouse;

        public Keystroke(int number, KeyMapping keyCode, String overrideName, boolean always) {
            super(null);
            this.height = 16;
            this.toggle = number == -1;
            this.width = 16;
            if (!this.toggle) {
                this.width = number == 2 ? 24 + KeystrokeWidget.this.innerPadding : 16;
                this.key = KeybindHelper.getBoundKey((KeyMapping)keyCode);
                this.overrideName = overrideName;
                this.isMouse = this.key.getType() == InputConstants.Type.MOUSE;
            }
            this.useKeybinds = always ? false : KeystrokeWidget.this.useKeybinds;
        }

        public Keystroke(int number, KeyMapping keyCode, String overrideName) {
            this(number, keyCode, overrideName, false);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void render(GuiGraphics guiGraphics, int i, int i1) {
            if (this.toggle) {
                return;
            }
            boolean bl = this.key.getValue() != -1 && (this.isMouse ? ModUtil.isMouseDown(this.key.getValue()) : InputConstants.isKeyDown((Window)ClientUtils.getClient().getWindow(), (int)this.key.getValue()));
            int color = this.key.getValue() != -1 && bl ? KeystrokeWidget.this.downColor : KeystrokeWidget.this.upColor;
            RenderUtils.drawSquare((GuiGraphics)guiGraphics, (int)i, (int)i1, (int)this.width, (int)this.height, (int)color);
            RenderUtils.drawTextCentered((GuiGraphics)guiGraphics, (Component)(this.useKeybinds ? this.key.getDisplayName() : Component.literal((String)this.overrideName)), (int)(i + this.width / 2), (int)(i1 + 4));
        }
    }
}

