/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.widget.system;

import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.widget.SimpleTextWidget;
import dev.boxadactle.boxhud.widget.Widgets;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.util.GuiUtils;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MemoryWidget
implements Widgets.System,
SimpleTextWidget {
    boolean showPercentage = true;
    boolean showMax = true;

    private long bytesToMegabytes(long l) {
        return l / 1024L / 1024L;
    }

    @Override
    public Component getText() {
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long using = total - free;
        MutableComponent text = Component.empty();
        if (this.showMax) {
            text.append(String.format("%03d/%03dMB ", this.bytesToMegabytes(using), this.bytesToMegabytes(max)));
        } else {
            text.append(String.format("%03dMB ", this.bytesToMegabytes(using)));
        }
        if (this.showPercentage) {
            long percentage = using * 100L / max;
            text.append(GuiUtils.parentheses((Component)Component.literal((String)String.format("%2d%%", percentage)).withColor(percentage > 90L ? GuiUtils.RED : GuiUtils.WHITE)));
        }
        return this.definition("text", text);
    }

    @Override
    public HudWidget.ConfigFactory<?> getConfigFactory() {
        return new HudWidget.ConfigFactory<MemoryWidget>(this){

            @Override
            protected void addCustomConfigEntries(WidgetEntry<MemoryWidget> entry, Consumer<BOptionEntry<?>> consumer) {
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.memory.showPercentage", Boolean.valueOf(((MemoryWidget)entry.widget).showPercentage), value -> {
                    ((MemoryWidget)entry.widget).showPercentage = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.memory.showMax", Boolean.valueOf(((MemoryWidget)entry.widget).showMax), value -> {
                    ((MemoryWidget)entry.widget).showMax = value;
                }));
            }
        };
    }

    @Override
    public String getNameKey() {
        return "memory";
    }

    @Override
    public int getDefaultX() {
        return 0;
    }

    @Override
    public int getDefaultY() {
        return 35;
    }

    @Override
    public boolean defaultEnabled() {
        return false;
    }
}

