/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.widget.vanilla;

import dev.boxadactle.boxhud.PositionModifiers;
import dev.boxadactle.boxhud.mixin.GuiInvoker;
import dev.boxadactle.boxhud.widget.VanillaWidget;
import dev.boxadactle.boxlib.math.geometry.Dimension;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.WorldUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class ScoreboardWidget
implements VanillaWidget {
    transient int width = 0;
    transient int height = 0;
    transient int plWidth = 0;
    transient int plHeight = 0;

    public int calculateSidebarScoreboardWidth(Objective objective) {
        Scoreboard scoreboard = objective.getScoreboard();
        NumberFormat numberFormat = objective.numberFormatOrDefault((NumberFormat)StyledFormat.SIDEBAR_DEFAULT);
        record DisplayEntry(Component name, Component score, int scoreWidth) {
        }
        DisplayEntry[] entries = (DisplayEntry[])scoreboard.listPlayerScores(objective).stream().filter(scoreEntry -> !scoreEntry.isHidden()).limit(15L).map(scoreEntry -> {
            PlayerTeam team = scoreboard.getPlayersTeam(scoreEntry.owner());
            MutableComponent name = PlayerTeam.formatNameForTeam((Team)team, (Component)scoreEntry.ownerName());
            MutableComponent score = scoreEntry.formatValue(numberFormat);
            int scoreWidth = GuiUtils.getTextSize((Component)score);
            return new DisplayEntry((Component)name, (Component)score, scoreWidth);
        }).toArray(x$0 -> new DisplayEntry[x$0]);
        Component displayName = objective.getDisplayName();
        int width = GuiUtils.getTextSize((Component)displayName);
        int spacerWidth = GuiUtils.getTextRenderer().width(": ");
        for (DisplayEntry entry : entries) {
            int entryWidth = GuiUtils.getTextSize((Component)entry.name()) + (entry.scoreWidth() > 0 ? spacerWidth + entry.scoreWidth() : 0);
            width = Math.max(width, entryWidth);
        }
        return width + 4;
    }

    public int calculateSidebarScoreboardHeight(Objective objective) {
        Scoreboard scoreboard = objective.getScoreboard();
        long entryCount = scoreboard.listPlayerScores(objective).stream().filter(scoreEntry -> !scoreEntry.isHidden()).limit(15L).count();
        return (int)entryCount * 9 + 9 + 2 + 1;
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y) {
        Objective objective1;
        DisplaySlot displayslot;
        this.renderPositioned(graphics, x, y, () -> ((GuiInvoker)ClientUtils.getClient().gui).invokeRenderScoreboardSidebar(graphics, this.getDummyTracker()));
        Scoreboard scoreboard = WorldUtils.getWorld().getScoreboard();
        Objective objective = null;
        PlayerTeam playerteam = scoreboard.getPlayersTeam(WorldUtils.getPlayer().getScoreboardName());
        if (playerteam != null && (displayslot = DisplaySlot.teamColorToSlot((ChatFormatting)playerteam.getColor())) != null) {
            objective = scoreboard.getDisplayObjective(displayslot);
        }
        Objective objective2 = objective1 = objective != null ? objective : scoreboard.getDisplayObjective(DisplaySlot.SIDEBAR);
        if (objective1 != null) {
            this.width = this.calculateSidebarScoreboardWidth(objective1);
            this.height = this.calculateSidebarScoreboardHeight(objective1);
        } else {
            this.width = 0;
            this.height = 0;
        }
    }

    @Override
    public void renderPlaceholder(GuiGraphics graphics, int x, int y) {
        this.renderPositioned(graphics, x, y, () -> {
            Scoreboard s = new Scoreboard();
            Objective obj = s.addObjective("placeholder", ObjectiveCriteria.DUMMY, (Component)Component.literal((String)"Placeholder Objective"), ObjectiveCriteria.RenderType.INTEGER, false, null);
            s.getOrCreatePlayerScore(ScoreHolder.forNameOnly((String)"Placeholder Player"), obj);
            s.getOrCreatePlayerScore(ScoreHolder.forNameOnly((String)"Another Player"), obj);
            s.getOrCreatePlayerScore(ScoreHolder.forNameOnly((String)"Third Player"), obj);
            s.getOrCreatePlayerScore(ScoreHolder.forNameOnly((String)"Fourth Player"), obj);
            ((GuiInvoker)ClientUtils.getClient().gui).invokeDrawScoreboardSidebar(graphics, obj);
            this.plWidth = this.calculateSidebarScoreboardWidth(obj);
            this.plHeight = this.calculateSidebarScoreboardHeight(obj);
        });
    }

    @Override
    public Dimension<Integer> getSize() {
        return new Dimension((Number)this.width, (Number)this.height);
    }

    @Override
    public Dimension<Integer> getPlaceholderSize() {
        return new Dimension((Number)this.plWidth, (Number)this.plHeight);
    }

    @Override
    public String getNameKey() {
        return "scoreboard";
    }

    @Override
    public int getDefaultX() {
        return 0;
    }

    @Override
    public int getDefaultY() {
        return -10;
    }

    @Override
    public PositionModifiers getDefaultModifier() {
        return PositionModifiers.RIGHT;
    }
}

