/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud;

import com.mojang.brigadier.builder.ArgumentBuilder;
import dev.boxadactle.boxhud.BoxWidgets;
import dev.boxadactle.boxhud.CoordinatesDisplayWrapper;
import dev.boxadactle.boxhud.ModConfig;
import dev.boxadactle.boxhud.WidgetPositionScreen;
import dev.boxadactle.boxhud.widget.general.CompassWidget;
import dev.boxadactle.boxhud.widget.general.ItemInfoWidget;
import dev.boxadactle.boxhud.widget.general.PlayerCountWidget;
import dev.boxadactle.boxhud.widget.general.ResourcePackWidget;
import dev.boxadactle.boxhud.widget.general.ServerInfoWidget;
import dev.boxadactle.boxhud.widget.general.TimeWidget;
import dev.boxadactle.boxhud.widget.pvp.ArmorWidget;
import dev.boxadactle.boxhud.widget.pvp.ArrowWidget;
import dev.boxadactle.boxhud.widget.pvp.ComboWidget;
import dev.boxadactle.boxhud.widget.pvp.PotionsWidget;
import dev.boxadactle.boxhud.widget.pvp.ReachWidget;
import dev.boxadactle.boxhud.widget.pvp.SpeedWidget;
import dev.boxadactle.boxhud.widget.system.CoordinatesWidget;
import dev.boxadactle.boxhud.widget.system.CpsWidget;
import dev.boxadactle.boxhud.widget.system.FpsWidget;
import dev.boxadactle.boxhud.widget.system.KeystrokeWidget;
import dev.boxadactle.boxhud.widget.system.MemoryWidget;
import dev.boxadactle.boxhud.widget.system.PingWidget;
import dev.boxadactle.boxhud.widget.system.TpsWidget;
import dev.boxadactle.boxhud.widget.vanilla.ActionbarWidget;
import dev.boxadactle.boxhud.widget.vanilla.BossbarWidget;
import dev.boxadactle.boxhud.widget.vanilla.CrosshairWidget;
import dev.boxadactle.boxhud.widget.vanilla.HotbarWidget;
import dev.boxadactle.boxhud.widget.vanilla.ScoreboardWidget;
import dev.boxadactle.boxlib.command.BCommandManager;
import dev.boxadactle.boxlib.command.BCommandSourceStack;
import dev.boxadactle.boxlib.command.api.BCommand;
import dev.boxadactle.boxlib.command.api.BSubcommand;
import dev.boxadactle.boxlib.config.BConfigClass;
import dev.boxadactle.boxlib.config.BConfigHandler;
import dev.boxadactle.boxlib.scheduling.Scheduling;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.ModLogger;
import java.io.File;
import java.util.Set;
import net.minecraft.class_310;
import net.minecraft.class_437;

public final class Boxhud {
    public static final String MOD_ID = "boxhud";
    public static final String MOD_VERSION = "7.0.0";
    public static final ModLogger LOGGER = new ModLogger("boxhud");
    public static BConfigClass<ModConfig> CONFIG;
    public static File widgetConfigFile;
    public static boolean cdInstalled;

    public static void init() {
        LOGGER.info((Object)"Initializing Boxhud version 7.0.0", new Object[0]);
        CONFIG = BConfigHandler.registerConfig(ModConfig.class);
        widgetConfigFile = ClientUtils.getConfigFolder().resolve("boxhud-widgets.json").toFile();
        BoxWidgets.loadConfig(widgetConfigFile);
        BoxWidgets.saveConfig(widgetConfigFile);
    }

    public static boolean isCoordinatesdisplayInstalled() {
        try {
            Class.forName("dev.boxadactle.coordinatesdisplay.CoordinatesDisplay");
            LOGGER.info((Object)"CoordinatesDisplay is installed!", new Object[0]);
            return true;
        }
        catch (ClassNotFoundException e) {
            LOGGER.info((Object)"CoordinatesDisplay is not installed :(. Coordinates widget will have limited functionality.", new Object[0]);
            return false;
        }
    }

    public static void tick() {
        BoxWidgets.tickWidgets();
        if (cdInstalled) {
            Boxhud.optDep(CoordinatesDisplayWrapper::disableModRendering);
        }
    }

    public static ModConfig getConfig() {
        return (ModConfig)CONFIG.get();
    }

    public static void optDep(Runnable run) {
        try {
            run.run();
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn((Object)("Optional dependency not found: " + e.getMessage()), new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occurred while executing optional dependency code: ", new Object[]{e});
            LOGGER.printStackTrace(e);
        }
    }

    static {
        cdInstalled = Boxhud.isCoordinatesdisplayInstalled();
        BoxWidgets.registerWidget("cps", CpsWidget.class);
        BoxWidgets.registerWidget("fps", FpsWidget.class);
        BoxWidgets.registerWidget("memory", MemoryWidget.class);
        BoxWidgets.registerWidget("ping", PingWidget.class);
        BoxWidgets.registerWidget("armor", ArmorWidget.class);
        BoxWidgets.registerWidget("arrow", ArrowWidget.class);
        BoxWidgets.registerWidget("compass", CompassWidget.class);
        BoxWidgets.registerWidget("coordinates", CoordinatesWidget.class);
        BoxWidgets.registerWidget("iteminfo", ItemInfoWidget.class);
        BoxWidgets.registerWidget("potions", PotionsWidget.class);
        BoxWidgets.registerWidget("resourcepack", ResourcePackWidget.class);
        BoxWidgets.registerWidget("serverinfo", ServerInfoWidget.class);
        BoxWidgets.registerWidget("time", TimeWidget.class);
        BoxWidgets.registerWidget("playercount", PlayerCountWidget.class);
        BoxWidgets.registerWidget("keystroke", KeystrokeWidget.class);
        BoxWidgets.registerWidget("speed", SpeedWidget.class);
        BoxWidgets.registerWidget("combo", ComboWidget.class);
        BoxWidgets.registerWidget("tps", TpsWidget.class);
        BoxWidgets.registerWidget("reach", ReachWidget.class);
        BoxWidgets.registerWidget("bossbar", BossbarWidget.class);
        BoxWidgets.registerWidget("crosshair", CrosshairWidget.class);
        BoxWidgets.registerWidget("hotbar", HotbarWidget.class);
        BoxWidgets.registerWidget("actionbar", ActionbarWidget.class);
        BoxWidgets.registerWidget("scoreboard", ScoreboardWidget.class);
        BCommandManager.register((BCommand)BCommand.create((String)MOD_ID, c -> {
            Scheduling.nextTick(() -> ClientUtils.setScreen((class_437)new WidgetPositionScreen(null)));
            return 0;
        }).registerSubcommand(new BSubcommand(){

            public ArgumentBuilder<BCommandSourceStack, ?> getSubcommand() {
                return BCommandManager.literal((String)"disable");
            }

            public void build(ArgumentBuilder<BCommandSourceStack, ?> argumentBuilder) {
                Set<String> ids = BoxWidgets.widgetRegistry.keySet();
                for (String id : ids) {
                    argumentBuilder.then(BCommandManager.literal((String)id).executes(context -> {
                        BoxWidgets.getWidgetEntry((String)id).enabled = false;
                        BoxWidgets.saveConfig(widgetConfigFile);
                        class_310.method_1551().method_1507((class_437)new WidgetPositionScreen(null));
                        return 0;
                    }));
                }
            }
        }).registerSubcommand(new BSubcommand(){

            public ArgumentBuilder<BCommandSourceStack, ?> getSubcommand() {
                return BCommandManager.literal((String)"enable");
            }

            public void build(ArgumentBuilder<BCommandSourceStack, ?> argumentBuilder) {
                Set<String> ids = BoxWidgets.widgetRegistry.keySet();
                for (String id : ids) {
                    argumentBuilder.then(BCommandManager.literal((String)id).executes(context -> {
                        BoxWidgets.getWidgetEntry((String)id).enabled = true;
                        BoxWidgets.saveConfig(widgetConfigFile);
                        class_310.method_1551().method_1507((class_437)new WidgetPositionScreen(null));
                        return 0;
                    }));
                }
            }
        }));
    }
}

