/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class FpsTracker {
    public static int maxHistory = 250;
    private static final LinkedList<Integer> history = new LinkedList();

    public static int getMinimum() {
        return Collections.min(history);
    }

    public int getMaximum() {
        return Collections.max(history);
    }

    public static int getAverage() {
        int sum = 0;
        Iterator iterator = history.iterator();
        while (iterator.hasNext()) {
            int fps = (Integer)iterator.next();
            sum += fps;
        }
        return sum / history.size();
    }

    public static int getMs() {
        int averageFps = FpsTracker.getAverage();
        if (averageFps == 0) {
            return 0;
        }
        return 1000 / averageFps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLagScore() {
        LinkedList<Integer> linkedList = history;
        synchronized (linkedList) {
            if (history.isEmpty()) {
                return 0;
            }
            int count = 0;
            double sumMs = 0.0;
            Iterator iterator = history.iterator();
            while (iterator.hasNext()) {
                int fps = (Integer)iterator.next();
                if (fps <= 0) continue;
                sumMs += 1000.0 / (double)fps;
                ++count;
            }
            if (count == 0) {
                return 0;
            }
            double meanMs = sumMs / (double)count;
            double varSum = 0.0;
            Iterator iterator2 = history.iterator();
            while (iterator2.hasNext()) {
                int fps = (Integer)iterator2.next();
                if (fps <= 0) continue;
                double ms = 1000.0 / (double)fps;
                double diff = ms - meanMs;
                varSum += diff * diff;
            }
            double variance = varSum / (double)count;
            double stdev = Math.sqrt(variance);
            if (meanMs == 0.0) {
                return 0;
            }
            return (int)(stdev / meanMs * 100.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recent(int fps) {
        LinkedList<Integer> linkedList = history;
        synchronized (linkedList) {
            history.addLast(fps);
            while (history.size() > maxHistory) {
                history.removeFirst();
            }
        }
    }
}

