/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.widget.general;

import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.PositionModifiers;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.util.InventoryUtils;
import dev.boxadactle.boxhud.widget.Widgets;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BColorPickerButton;
import dev.boxadactle.boxlib.gui.config.widget.slider.BIntegerSlider;
import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.TextComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ItemInfoWidget
implements Widgets.General {
    private final transient List<ItemChangeEntry> items = new ArrayList<ItemChangeEntry>();
    private transient List<class_1799> previousItems = new ArrayList<class_1799>();
    public int itemExpiry = 5;
    public int additionColor = GuiUtils.GREEN;
    public int removalColor = GuiUtils.RED;
    public int countColor = GuiUtils.WHITE;

    @Override
    public String getNameKey() {
        return "iteminfo";
    }

    private void addComponent(InventoryUtils.ItemChange change) {
        if (change.stack().method_7960() || change.stack().method_31574(class_1802.field_8162)) {
            return;
        }
        class_1799 item = change.stack().method_7972();
        item.method_7939(Math.abs(change.delta()));
        if (this.items.stream().anyMatch(entry -> entry.newItems(item, change.delta()))) {
            return;
        }
        this.items.add(new ItemChangeEntry(item, change.delta()));
        if (this.items.size() > 5) {
            this.items.removeFirst();
        }
    }

    private void update() {
        class_1657 player = WorldUtils.getPlayer();
        if (player == null) {
            return;
        }
        List<class_1799> current = InventoryUtils.getItemList(player);
        List<InventoryUtils.ItemChange> changes = InventoryUtils.compare(this.previousItems, current);
        changes.forEach(this::addComponent);
        this.previousItems = current;
    }

    @Override
    public void tick() {
        this.items.removeIf(item -> {
            item.tick();
            return item.despawn <= 0;
        });
    }

    private RenderingLayout widget(boolean isPlaceholder) {
        this.update();
        ColumnLayout layout = new ColumnLayout(0, 0, 3);
        if (!isPlaceholder) {
            for (int i = Math.max(0, this.items.size() - 5); i < this.items.size(); ++i) {
                layout.addComponent((LayoutComponent)new TextComponent(this.items.get(i).createComponent()));
            }
        } else {
            layout.addComponent((LayoutComponent)new TextComponent(new ItemChangeEntry(new class_1799((class_1935)class_1802.field_8477, 23), 23).createComponent()));
            layout.addComponent((LayoutComponent)new TextComponent(new ItemChangeEntry(new class_1799((class_1935)class_1802.field_8695, 5), -5).createComponent()));
            layout.addComponent((LayoutComponent)new TextComponent(new ItemChangeEntry(new class_1799((class_1935)class_1802.field_8620, 10), 10).createComponent()));
            layout.addComponent((LayoutComponent)new TextComponent(new ItemChangeEntry(new class_1799((class_1935)class_1802.field_8687, 2), -23).createComponent()));
            layout.addComponent((LayoutComponent)new TextComponent(new ItemChangeEntry(new class_1799((class_1935)class_1802.field_8713, 15), 5).createComponent()));
        }
        return layout;
    }

    @Override
    public RenderingLayout createWidget(int x, int y) {
        return new PaddingLayout(x, y, this.padding(), this.widget(false));
    }

    @Override
    public RenderingLayout createPlaceholderWidget(int x, int y) {
        return new PaddingLayout(x, y, this.padding(), this.widget(true));
    }

    @Override
    public HudWidget.ConfigFactory<?> getConfigFactory() {
        return new HudWidget.ConfigFactory<ItemInfoWidget>(this){

            @Override
            protected void addCustomConfigEntries(WidgetEntry<ItemInfoWidget> entry, Consumer<BOptionEntry<?>> consumer) {
                consumer.accept((BOptionEntry<?>)new BIntegerSlider("boxhud.widget.iteminfo.itemExpiry", 0, 10, ((ItemInfoWidget)entry.widget).itemExpiry, value -> {
                    ((ItemInfoWidget)entry.widget).itemExpiry = value;
                }));
                consumer.accept((BOptionEntry<?>)new BColorPickerButton("boxhud.widget.iteminfo.additionColor", (class_437)this.screen, false, Integer.valueOf(((ItemInfoWidget)entry.widget).additionColor), c -> {
                    ((ItemInfoWidget)entry.widget).additionColor = c;
                }));
                consumer.accept((BOptionEntry<?>)new BColorPickerButton("boxhud.widget.iteminfo.removalColor", (class_437)this.screen, false, Integer.valueOf(((ItemInfoWidget)entry.widget).removalColor), c -> {
                    ((ItemInfoWidget)entry.widget).removalColor = c;
                }));
                consumer.accept((BOptionEntry<?>)new BColorPickerButton("boxhud.widget.iteminfo.countColor", (class_437)this.screen, false, Integer.valueOf(((ItemInfoWidget)entry.widget).countColor), c -> {
                    ((ItemInfoWidget)entry.widget).countColor = c;
                }));
            }
        };
    }

    @Override
    public int getDefaultX() {
        return 0;
    }

    @Override
    public int getDefaultY() {
        return 15;
    }

    @Override
    public boolean defaultEnabled() {
        return false;
    }

    @Override
    public PositionModifiers getDefaultModifier() {
        return PositionModifiers.BOTTOM_LEFT;
    }

    public class ItemChangeEntry {
        public final class_1799 item;
        public int count;
        public int despawn;

        public ItemChangeEntry(class_1799 item, int count) {
            this.despawn = ItemInfoWidget.this.itemExpiry * 20;
            this.item = item;
            this.count = count;
        }

        public void tick() {
            if (this.despawn > 0) {
                --this.despawn;
            }
        }

        public boolean newItems(class_1799 item, int change) {
            if (item.method_31574(this.item.method_7909())) {
                this.count += change;
                this.despawn = this.count != 0 ? ItemInfoWidget.this.itemExpiry * 20 : 0;
                return true;
            }
            return false;
        }

        public class_2561 createComponent() {
            class_5250 count = class_2561.method_43470((String)(Math.abs(this.count) + "x")).method_54663(ItemInfoWidget.this.countColor);
            class_2561 itemName = this.item.method_7964();
            if (this.count > 0) {
                return ItemInfoWidget.this.translation("add", count, itemName.method_27661().method_54663(ItemInfoWidget.this.additionColor)).method_27661().method_54663(ItemInfoWidget.this.additionColor);
            }
            return ItemInfoWidget.this.translation("remove", count, itemName.method_27661().method_54663(ItemInfoWidget.this.removalColor)).method_27661().method_54663(ItemInfoWidget.this.removalColor);
        }
    }
}

