/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.widget.pvp;

import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.PositionModifiers;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.events.BoxEvents;
import dev.boxadactle.boxhud.widget.Widgets;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.gui.config.widget.slider.BIntegerSlider;
import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.TextComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.math.mathutils.NumberFormatter;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ReachWidget
implements Widgets.Pvp {
    public int resetAfter = 10;
    public boolean resetOnNewTarget = true;
    public int decimalPlaces = 2;
    public int textPadding = 2;
    public boolean showLast = true;
    public boolean showMax = true;
    public boolean showAverage = true;
    transient List<Double> reachDistances = new ArrayList<Double>();
    transient long lastHit = 0L;
    transient int target = -1;

    @Override
    public String getNameKey() {
        return "reach";
    }

    @Override
    public void tick() {
        if (this.target != -1 && System.currentTimeMillis() - this.lastHit > (long)this.resetAfter * 1000L) {
            this.reachDistances.clear();
            this.target = -1;
        }
    }

    @Override
    public void init() {
        BoxEvents.ENTITY_ATTACK.register(this::onAttack);
    }

    public void onAttack(class_1297 entity) {
        if (this.target == -1 || this.resetOnNewTarget && entity.method_5628() != this.target) {
            this.target = entity.method_5628();
            this.reachDistances.clear();
        } else {
            class_1297 me = WorldUtils.getCamera();
            this.reachDistances.add(Math.sqrt(me.method_5858(entity)));
        }
        this.lastHit = System.currentTimeMillis();
    }

    public class_2561 getColor(double reach) {
        if (reach <= 3.5) {
            return GuiUtils.colorize((class_2561)class_2561.method_43470((String)"G"), (int)GuiUtils.GREEN);
        }
        if (reach <= 4.0) {
            return GuiUtils.colorize((class_2561)class_2561.method_43470((String)"B"), (int)GuiUtils.YELLOW);
        }
        return GuiUtils.colorize((class_2561)class_2561.method_43470((String)"S"), (int)GuiUtils.RED);
    }

    @Override
    public RenderingLayout createWidget(int x, int y) {
        ColumnLayout layout = new ColumnLayout(0, 0, this.textPadding);
        if (this.reachDistances.isEmpty()) {
            layout.addComponent((LayoutComponent)new TextComponent(this.definition("text", this.value("-"))));
            if (this.showLast) {
                layout.addComponent((LayoutComponent)new TextComponent(this.definition("last", this.value("-"))));
            }
            if (this.showMax) {
                layout.addComponent((LayoutComponent)new TextComponent(this.definition("max", this.value("-"))));
            }
            if (this.showAverage) {
                layout.addComponent((LayoutComponent)new TextComponent(this.definition("avg", this.value("-"))));
            }
        } else {
            NumberFormatter formatter = new NumberFormatter(this.decimalPlaces);
            class_2561 sus = this.value(GuiUtils.parentheses((class_2561)this.getColor(this.reachDistances.getLast())));
            class_5250 val = class_2561.method_43470((String)formatter.formatDecimal((Number)this.reachDistances.getLast()));
            layout.addComponent((LayoutComponent)new TextComponent(this.definition("text", this.value((class_2561)val.method_27661().method_27693(" ").method_10852(sus)))));
            if (this.showLast) {
                String last = this.reachDistances.size() >= 2 ? formatter.formatDecimal((Number)this.reachDistances.get(this.reachDistances.size() - 2)) : "-";
                layout.addComponent((LayoutComponent)new TextComponent(this.definition("last", this.value(last))));
            }
            if (this.showMax) {
                double max = this.reachDistances.stream().mapToDouble(Double::doubleValue).max().orElse(0.0);
                String maxStr = max > 0.0 ? formatter.formatDecimal((Number)max) : "-";
                layout.addComponent((LayoutComponent)new TextComponent(this.definition("max", this.value(maxStr))));
            }
            if (this.showAverage) {
                double average = this.reachDistances.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
                String avgStr = average > 0.0 ? formatter.formatDecimal((Number)average) : "-";
                layout.addComponent((LayoutComponent)new TextComponent(this.definition("avg", this.value(avgStr))));
            }
        }
        return new PaddingLayout(x, y, this.padding(), (RenderingLayout)layout);
    }

    public HudWidget.ConfigFactory<ReachWidget> getConfigFactory() {
        return new HudWidget.ConfigFactory<ReachWidget>(this){

            @Override
            protected void addCustomConfigEntries(WidgetEntry<ReachWidget> entry, Consumer<BOptionEntry<?>> consumer) {
                consumer.accept((BOptionEntry<?>)new BIntegerSlider("boxhud.widget.reach.resetAfter", 1, 60, ((ReachWidget)entry.widget).resetAfter, value -> {
                    ((ReachWidget)entry.widget).resetAfter = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.reach.resetOnNewTarget", Boolean.valueOf(((ReachWidget)entry.widget).resetOnNewTarget), value -> {
                    ((ReachWidget)entry.widget).resetOnNewTarget = value;
                }));
                consumer.accept((BOptionEntry<?>)new BIntegerSlider("boxhud.widget.reach.decimalPlaces", 0, 5, ((ReachWidget)entry.widget).decimalPlaces, value -> {
                    ((ReachWidget)entry.widget).decimalPlaces = value;
                }));
                consumer.accept((BOptionEntry<?>)new BIntegerSlider("boxhud.widget.reach.textPadding", 0, 4, ((ReachWidget)entry.widget).textPadding, value -> {
                    ((ReachWidget)entry.widget).textPadding = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.reach.showLast", Boolean.valueOf(((ReachWidget)entry.widget).showLast), value -> {
                    ((ReachWidget)entry.widget).showLast = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.reach.showMax", Boolean.valueOf(((ReachWidget)entry.widget).showMax), value -> {
                    ((ReachWidget)entry.widget).showMax = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.reach.showAvg", Boolean.valueOf(((ReachWidget)entry.widget).showAverage), value -> {
                    ((ReachWidget)entry.widget).showAverage = value;
                }));
            }
        };
    }

    @Override
    public int getDefaultX() {
        return 10;
    }

    @Override
    public int getDefaultY() {
        return 0;
    }

    @Override
    public PositionModifiers getDefaultModifier() {
        return PositionModifiers.LEFT;
    }

    @Override
    public boolean defaultEnabled() {
        return false;
    }
}

