/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.widget.system;

import dev.boxadactle.boxhud.BoxWidgets;
import dev.boxadactle.boxhud.Boxhud;
import dev.boxadactle.boxhud.CoordinatesDisplayWrapper;
import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.util.ModUtil;
import dev.boxadactle.boxhud.widget.Widgets;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.gui.config.widget.slider.BIntegerSlider;
import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.LayoutContainerComponent;
import dev.boxadactle.boxlib.layouts.component.LeftParagraphComponent;
import dev.boxadactle.boxlib.layouts.component.ParagraphComponent;
import dev.boxadactle.boxlib.layouts.component.TextComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.boxlib.util.WorldUtils;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class CoordinatesWidget
implements Widgets.System {
    public int textPadding = 5;
    public boolean renderDirection = true;
    public boolean renderBiome = true;

    private class_2561[] createDirectionComponents(double yaw) {
        String[][] directions = new String[][]{{" ", "+"}, {"-", "+"}, {"-", " "}, {"-", "-"}, {" ", "-"}, {"+", "-"}, {"+", " "}, {"+", "+"}};
        String[] direction = directions[(int)Math.round(yaw / 45.0) & 7];
        return new class_2561[]{class_2561.method_43470((String)direction[0]), this.translation(ModUtil.getDirectionFromYaw(yaw), new Object[0]), class_2561.method_43470((String)direction[1])};
    }

    @Override
    public void tick() {
        if (Boxhud.cdInstalled) {
            Boxhud.optDep(() -> {
                BoxWidgets.getWidgetEntry((String)"coordinates").renderBackground = CoordinatesDisplayWrapper.getBackgroundEnabled();
            });
        }
    }

    @Override
    public String getNameKey() {
        return "coords";
    }

    private RenderingLayout create(int x, int y, int z, class_2561 biome, double yaw) {
        RowLayout layout = new RowLayout(0, 0, this.textPadding);
        ColumnLayout row = new ColumnLayout(0, 0, this.textPadding / 2);
        class_2561 xtext = this.definition("x", this.value(Integer.toString(x)));
        class_2561 ytext = this.definition("y", this.value(Integer.toString(y)));
        class_2561 ztext = this.definition("y", this.value(Integer.toString(z)));
        ParagraphComponent paragraph = new ParagraphComponent(1, new class_2561[]{xtext, ytext, ztext});
        row.addComponent((LayoutComponent)paragraph);
        if (this.renderBiome) {
            row.addComponent((LayoutComponent)new TextComponent(biome));
        }
        layout.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)row));
        if (this.renderDirection) {
            class_2561[] directionTexts = this.createDirectionComponents(yaw);
            class_2561 xDirection = this.definition(directionTexts[0]);
            class_2561 directionText = this.value(directionTexts[1]);
            class_2561 zDirection = this.definition(directionTexts[2]);
            layout.addComponent((LayoutComponent)new LeftParagraphComponent(1, new class_2561[]{xDirection, directionText, zDirection}));
        }
        return layout;
    }

    private class_2960 getBiomeKey(class_6880<class_1959> b) {
        class_2960 def = class_2960.method_60655((String)"minecraft", (String)"plains");
        if (b == null) {
            return def;
        }
        return (class_2960)b.method_40229().map(class_5321::method_29177, biome -> def);
    }

    @Override
    public RenderingLayout createWidget(int x, int y) {
        ColumnLayout layout;
        if (Boxhud.cdInstalled) {
            layout = new AtomicReference(Optional.empty());
            Boxhud.optDep(() -> layout.set(CoordinatesDisplayWrapper.executePrerender(WorldUtils.getPlayer(), x, y)));
            if (((Optional)layout.get()).isPresent()) {
                return (RenderingLayout)((Optional)layout.get()).get();
            }
            Boxhud.LOGGER.error((Object)"Failed to get CoordinatesDisplay prerender, using default.", new Object[0]);
        }
        if (WorldUtils.getWorld() == null) {
            layout = new ColumnLayout(0, 0, 0);
            layout.addComponent((LayoutComponent)new TextComponent(this.definition("error", new Object[0])));
            return new PaddingLayout(x, y, this.padding(), (RenderingLayout)layout);
        }
        class_1657 player = WorldUtils.getPlayer();
        class_2338 b = new class_2338(player.method_31477(), player.method_31478(), player.method_31479());
        class_6880 biome = WorldUtils.getWorld().method_23753(b);
        class_2960 location = this.getBiomeKey((class_6880<class_1959>)biome);
        float yaw = class_3532.method_15393((float)player.method_36454());
        return new PaddingLayout(x, y, this.padding(), this.create(b.method_10263(), b.method_10264(), b.method_10260(), ModUtil.getBiomeComponent(location, (class_1959)biome.comp_349()), yaw));
    }

    @Override
    public RenderingLayout createPlaceholderWidget(int x, int y) {
        if (Boxhud.cdInstalled) {
            AtomicReference layout = new AtomicReference(Optional.empty());
            Boxhud.optDep(() -> layout.set(CoordinatesDisplayWrapper.executePrerender(null, x, y)));
            if (layout.get().isPresent()) {
                return (RenderingLayout)layout.get().get();
            }
            Boxhud.LOGGER.error((Object)"Failed to get CoordinatesDisplay prerender, using default.", new Object[0]);
        }
        return new PaddingLayout(x, y, this.padding(), this.create(302, -32, 1932, (class_2561)class_2561.method_43470((String)"Plains"), 183.0));
    }

    @Override
    public class_437 getConfigScreen(class_437 parent, WidgetEntry<?> entry) {
        if (Boxhud.cdInstalled) {
            AtomicReference s = new AtomicReference();
            Boxhud.optDep(() -> s.set(CoordinatesDisplayWrapper.getConfigScreen(parent)));
            if (s.get() != null) {
                return (class_437)s.get();
            }
            Boxhud.LOGGER.error((Object)"Failed to get CoordinatesDisplay config screen, using default.", new Object[0]);
        }
        return Widgets.System.super.getConfigScreen(parent, entry);
    }

    @Override
    public HudWidget.ConfigFactory<?> getConfigFactory() {
        return new HudWidget.ConfigFactory<CoordinatesWidget>(this){

            @Override
            protected void addCustomConfigEntries(WidgetEntry<CoordinatesWidget> entry, Consumer<BOptionEntry<?>> consumer) {
                consumer.accept((BOptionEntry<?>)new BIntegerSlider("boxhud.gui.widget.textPadding", 1, 10, ((CoordinatesWidget)entry.widget).textPadding, value -> {
                    ((CoordinatesWidget)entry.widget).textPadding = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.coords.renderBiome", Boolean.valueOf(((CoordinatesWidget)entry.widget).renderBiome), value -> {
                    ((CoordinatesWidget)entry.widget).renderBiome = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.coords.renderDirection", Boolean.valueOf(((CoordinatesWidget)entry.widget).renderDirection), value -> {
                    ((CoordinatesWidget)entry.widget).renderDirection = value;
                }));
            }
        };
    }

    @Override
    public int getDefaultX() {
        return 5;
    }

    @Override
    public int getDefaultY() {
        return 5;
    }

    @Override
    public boolean defaultEnabled() {
        return false;
    }
}

