/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.widget.vanilla;

import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.PositionModifiers;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.mixin.GuiInvoker;
import dev.boxadactle.boxhud.widget.VanillaWidget;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.widget.BCustomEntry;
import dev.boxadactle.boxlib.gui.config.widget.BSpacingEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.gui.config.widget.button.BColorPickerButton;
import dev.boxadactle.boxlib.gui.config.widget.button.BEnumButton;
import dev.boxadactle.boxlib.gui.config.widget.slider.BFloatSlider;
import dev.boxadactle.boxlib.math.geometry.Dimension;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.WorldUtils;
import java.util.function.Consumer;
import net.minecraft.class_10799;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class CrosshairWidget
implements VanillaWidget {
    public boolean allowDebugCrosshair = true;
    public CrosshairType crosshairType = CrosshairType.DEFAULT;
    public ColorType colorType = ColorType.DEFAULT;
    public int color = GuiUtils.AQUA;
    public float opacity = 1.0f;

    @Override
    public void render(class_332 graphics, int x, int y) {
        this.renderPositioned(graphics, x, y, () -> ((GuiInvoker)ClientUtils.getClient().field_1705).invokeRenderCrosshair(graphics, this.getDummyTracker()));
    }

    @Override
    public void renderPlaceholder(class_332 graphics, int x, int y) {
        this.renderCrosshair(graphics, x, y);
    }

    private boolean willCrit(class_1657 player) {
        boolean bl = player.method_7261(0.5f) > 0.9f;
        bl &= player.field_6017 > 0.0;
        bl &= !player.method_24828();
        bl &= !player.method_6101();
        bl &= !player.method_5799();
        bl &= !player.method_6059(class_1294.field_5919);
        bl &= !player.method_5765();
        return bl &= !player.method_5624();
    }

    private int getColor() {
        return switch (this.colorType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> -1;
            case 2 -> {
                class_239 res;
                if (ClientUtils.getClient().field_1692 != null && WorldUtils.getWorld() != null) {
                    if (ClientUtils.getClient().field_1692 instanceof class_1309) {
                        if (WorldUtils.getPlayer().method_7261(0.0f) >= 1.0f) {
                            if (this.willCrit(WorldUtils.getPlayer())) {
                                yield GuiUtils.RED;
                            }
                            yield 16754716;
                        }
                        yield GuiUtils.LIGHT_PURPLE;
                    }
                    yield GuiUtils.GRAY;
                }
                if (WorldUtils.getWorld() != null && (res = WorldUtils.getCamera().method_5745(WorldUtils.getPlayer().method_55754(), 0.0f, false)).method_17783().equals((Object)class_239.class_240.field_1332)) {
                    yield GuiUtils.GREEN;
                }
                yield GuiUtils.WHITE;
            }
            case 0 -> this.color;
        };
    }

    private int applyAlpha(int color) {
        int alpha = (int)(this.opacity * 255.0f);
        return color & 0xFFFFFF | alpha << 24;
    }

    public void renderCrosshair(class_332 guiGraphics, int x, int y) {
        if (this.crosshairType == CrosshairType.DEFAULT) {
            guiGraphics.method_52707(class_10799.field_56883, class_2960.method_60656((String)"hud/crosshair"), x, y, 15, 15, this.applyAlpha(this.getColor()));
        } else {
            guiGraphics.method_25291(class_10799.field_56883, this.crosshairType.texture, x, y, 0.0f, 0.0f, 15, 15, 15, 15, this.applyAlpha(this.getColor()));
        }
    }

    public HudWidget.ConfigFactory<CrosshairWidget> getConfigFactory() {
        return new HudWidget.ConfigFactory<CrosshairWidget>(){

            @Override
            protected void addCustomConfigEntries(WidgetEntry<CrosshairWidget> entry, Consumer<BOptionEntry<?>> consumer) {
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.crosshair.allowDebugCrosshair", Boolean.valueOf(((CrosshairWidget)entry.widget).allowDebugCrosshair), b -> {
                    ((CrosshairWidget)entry.widget).allowDebugCrosshair = b;
                }));
                consumer.accept((BOptionEntry<?>)new BEnumButton("boxhud.widget.crosshair.crosshairType", (Enum)((CrosshairWidget)entry.widget).crosshairType, CrosshairType.class, type -> {
                    ((CrosshairWidget)entry.widget).crosshairType = type;
                }, GuiUtils.AQUA));
                consumer.accept((BOptionEntry<?>)new BCustomEntry((guiGraphics, x, y, width, height, mouseX, mouseY, delta) -> {
                    guiGraphics.method_51448().pushMatrix();
                    guiGraphics.method_51448().translate((float)x.intValue() + (float)width.intValue() / 2.0f - 30.0f, (float)y.intValue());
                    guiGraphics.method_51448().scale(4.0f);
                    CrosshairWidget.this.renderCrosshair((class_332)guiGraphics, 0, 0);
                    guiGraphics.method_51448().popMatrix();
                }));
                consumer.accept((BOptionEntry<?>)new BSpacingEntry());
                consumer.accept((BOptionEntry<?>)new BSpacingEntry());
                consumer.accept((BOptionEntry<?>)new BEnumButton("boxhud.widget.crosshair.colorType", (Enum)((CrosshairWidget)entry.widget).colorType, ColorType.class, type -> {
                    ((CrosshairWidget)entry.widget).colorType = type;
                }, GuiUtils.AQUA));
                consumer.accept((BOptionEntry<?>)new BColorPickerButton("boxhud.widget.crosshair.color", (class_437)this.screen, false, Integer.valueOf(((CrosshairWidget)entry.widget).color), color -> {
                    ((CrosshairWidget)entry.widget).color = color;
                }));
                consumer.accept((BOptionEntry<?>)new BFloatSlider("boxhud.widget.crosshair.opacity", 0.0f, 1.0f, ((CrosshairWidget)entry.widget).opacity, 2, value -> {
                    ((CrosshairWidget)entry.widget).opacity = value.floatValue();
                }));
            }
        };
    }

    @Override
    public Dimension<Integer> getSize() {
        return new Dimension((Number)15, (Number)15);
    }

    @Override
    public String getNameKey() {
        return "crosshair";
    }

    @Override
    public int getDefaultX() {
        return 0;
    }

    @Override
    public int getDefaultY() {
        return 0;
    }

    @Override
    public PositionModifiers getDefaultModifier() {
        return PositionModifiers.CENTER;
    }

    @Override
    public boolean allowMove() {
        return false;
    }

    public static enum CrosshairType {
        DEFAULT("null"),
        DOT("dot.png"),
        ARROW("arrow.png"),
        CIRCLE_AND_LINES("circle_lines.png"),
        DOT_AND_CIRCLE("dot_and_circle.png"),
        DOT_AND_LINES("dot_lines.png"),
        SQUARE_AND_CROSS("square_and_cross.png"),
        CROSS("cross.png"),
        SEPARATED_CROSS("lines.png"),
        BOX("box.png"),
        RING("ring.png"),
        DOUBLE_RING("double_ring.png");

        public final class_2960 texture;

        private CrosshairType(class_2960 texture) {
            this.texture = texture;
        }

        private CrosshairType(String n2) {
            this(class_2960.method_60655((String)"boxhud", (String)("textures/crosshairs/" + n2)));
        }
    }

    public static enum ColorType {
        CUSTOM,
        DEFAULT,
        DYNAMIC;

    }
}

