/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.boxadactle.boxhud.Boxhud;
import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.PositionModifiers;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxlib.core.BoxLib;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.profiling.Profiler;

public class BoxWidgets {
    static Map<String, WidgetEntry<?>> widgetConfigs = new HashMap();
    static HashMap<String, Class<? extends HudWidget>> widgetRegistry = new HashMap();

    public static void registerWidget(String id, Class<? extends HudWidget> clazz) {
        if (widgetRegistry.containsKey(id)) {
            Boxhud.LOGGER.warn((Object)"Widget with ID '{}' is already registered, skipping.", new Object[]{id});
            return;
        }
        widgetRegistry.put(id, clazz);
    }

    public static WidgetEntry<?> getWidgetEntry(String id) {
        if (!widgetConfigs.containsKey(id)) {
            Boxhud.LOGGER.warn((Object)"Widget with ID '{}' not found in configs, returning null.", new Object[]{id});
            return null;
        }
        WidgetEntry<?> entry = widgetConfigs.get(id);
        if (entry == null || entry.widget == null) {
            Boxhud.LOGGER.warn((Object)"Widget entry for '{}' is null, returning null.", new Object[]{id});
            return null;
        }
        return entry;
    }

    public static <T extends HudWidget> WidgetEntry<T> getWidgetEntryUnchecked(String id) {
        try {
            return BoxWidgets.getWidgetEntry(id);
        }
        catch (ClassCastException e) {
            Boxhud.LOGGER.error((Object)"Widget entry for '{}' is not of the expected type, returning null.", new Object[]{id, e});
            return null;
        }
        catch (Exception e) {
            Boxhud.LOGGER.error((Object)"Unexpected error while getting widget entry for '{}'", new Object[]{id, e});
            return null;
        }
    }

    static HashMap<String, WidgetEntry<?>> defaultConfigs() {
        HashMap defaults = new HashMap();
        for (Map.Entry<String, Class<? extends HudWidget>> entry : widgetRegistry.entrySet()) {
            String id = entry.getKey();
            Class<? extends HudWidget> clazz = entry.getValue();
            try {
                HudWidget widget = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                defaults.put(id, new WidgetEntry<HudWidget>(widget, widget.defaultEnabled(), widget.getDefaultX(), widget.getDefaultY(), widget.getDefaultScale(), widget.defaultRenderBackground(), widget.getDefaultModifier()));
            }
            catch (Exception e) {
                Boxhud.LOGGER.error((Object)"Failed to create default config for widget '{}'", new Object[]{id, e});
            }
        }
        return defaults;
    }

    public static void loadConfig(File configfile) {
        Boxhud.LOGGER.info((Object)"Loading BoxHUD config from %s", new Object[]{configfile});
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(Map.class, (Object)new ConfigDeserializer()).create();
            BufferedReader reader = new BufferedReader(new FileReader(configfile));
            widgetConfigs = (Map)gson.fromJson((Reader)reader, Map.class);
        }
        catch (Exception e) {
            Boxhud.LOGGER.error((Object)"Failed to load BoxHUD config from %s", new Object[]{configfile, e});
            widgetConfigs = BoxWidgets.defaultConfigs();
        }
        for (Map.Entry<String, Class<? extends HudWidget>> entry : widgetRegistry.entrySet()) {
            String id = entry.getKey();
            Class<? extends HudWidget> clazz = entry.getValue();
            if (!widgetConfigs.containsKey(id)) {
                HudWidget widget = (HudWidget)BoxLib.initializeClass(clazz);
                widgetConfigs.put(id, new WidgetEntry<HudWidget>(widget, widget.defaultEnabled(), widget.getDefaultX(), widget.getDefaultY(), widget.getDefaultScale(), widget.defaultRenderBackground(), widget.getDefaultModifier()));
                widget.init();
                continue;
            }
            WidgetEntry<?> entryConfig = widgetConfigs.get(id);
            if (entryConfig.widget.getClass() != clazz) {
                Boxhud.LOGGER.warn((Object)"Widget config for '{}' does not match registered class, resetting to default.", new Object[]{id});
                HudWidget widget = (HudWidget)BoxLib.initializeClass(clazz);
                widgetConfigs.put(id, new WidgetEntry<HudWidget>(widget, widget.defaultEnabled(), widget.getDefaultX(), widget.getDefaultY(), widget.getDefaultScale(), widget.defaultRenderBackground(), widget.getDefaultModifier()));
            }
            entryConfig.widget.init();
        }
    }

    public static void saveConfig(File configfile) {
        Boxhud.LOGGER.info((Object)"Saving BoxHUD config to %s", new Object[]{configfile});
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(widgetConfigs);
            FileWriter writer = new FileWriter(configfile);
            writer.write(json);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            Boxhud.LOGGER.error((Object)"Failed to save BoxHUD config to %s", new Object[]{configfile, e});
        }
    }

    public static void renderAll(GuiGraphics graphics) {
        for (Map.Entry<String, WidgetEntry<?>> entry : widgetConfigs.entrySet()) {
            WidgetEntry<?> hudEntry = entry.getValue();
            if (!hudEntry.enabled) continue;
            Profiler.get().push("boxhud.widget." + hudEntry.widget.getNameKey());
            hudEntry.render(graphics);
            Profiler.get().pop();
        }
    }

    public static void tickWidgets() {
        for (Map.Entry<String, WidgetEntry<?>> entry : widgetConfigs.entrySet()) {
            WidgetEntry<?> hudEntry = entry.getValue();
            if (!hudEntry.enabled) continue;
            hudEntry.widget.tick();
        }
    }

    static class ConfigDeserializer
    implements JsonDeserializer<Map<String, WidgetEntry<?>>> {
        ConfigDeserializer() {
        }

        public Map<String, WidgetEntry<?>> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            HashMap map = new HashMap();
            JsonObject jsonObject = json.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                String key = (String)entry.getKey();
                JsonObject value = ((JsonElement)entry.getValue()).getAsJsonObject();
                Class<? extends HudWidget> clazz = widgetRegistry.get(key);
                if (clazz != null) {
                    HudWidget widget = (HudWidget)context.deserialize(value.get("widget"), clazz);
                    boolean enabled = value.has("enabled") ? value.get("enabled").getAsBoolean() : widget.defaultEnabled();
                    int x = value.has("x") ? value.get("x").getAsInt() : widget.getDefaultX();
                    int y = value.has("y") ? value.get("y").getAsInt() : widget.getDefaultY();
                    float scale = value.has("scale") ? value.get("scale").getAsFloat() : widget.getDefaultScale();
                    boolean renderBackground = value.has("renderBackground") ? value.get("renderBackground").getAsBoolean() : widget.defaultRenderBackground();
                    PositionModifiers mod = value.has("modifier") ? PositionModifiers.valueOf(value.get("modifier").getAsString()) : widget.getDefaultModifier();
                    map.put(key, new WidgetEntry<HudWidget>(widget, enabled, x, y, scale, renderBackground, mod));
                    continue;
                }
                throw new JsonParseException("Unknown type key: " + key);
            }
            return map;
        }
    }
}

