/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud;

import dev.boxadactle.boxhud.BoxWidgets;
import dev.boxadactle.boxhud.Boxhud;
import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.WidgetConfigScreen;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.WidgetPositionScreen;
import dev.boxadactle.boxhud.util.IconButton;
import dev.boxadactle.boxlib.gui.config.BConfigList;
import dev.boxadactle.boxlib.gui.config.BOptionHelper;
import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.gui.config.widget.button.BScreenButton;
import dev.boxadactle.boxlib.gui.config.widget.label.BLabel;
import dev.boxadactle.boxlib.gui.widget.CenteredLabelWidget;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.math.geometry.Rect;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.RenderUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class WidgetListScreen
extends BOptionScreen {
    String search = "";

    public WidgetListScreen(Screen parent) {
        super(parent, (Component)Component.translatable((String)"boxhud.gui.widget"));
    }

    protected void addContents() {
        this.configList = new CustomConfigList(ClientUtils.getClient(), this);
        if (this.shouldRenderScrollingWidget()) {
            this.layout.addToContents((LayoutElement)this.configList);
        }
        this.addOptions();
    }

    protected int getHeaderHeight() {
        return super.getHeaderHeight() + 22;
    }

    protected int getRowWidth() {
        return super.getRowWidth() + 180;
    }

    protected int getScrollbarX() {
        return this.width - 10;
    }

    protected int getRowHeight() {
        return 70;
    }

    protected void addTitle() {
        LinearLayout title = (LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.vertical().spacing(this.getPadding()));
        title.addChild((LayoutElement)new CenteredLabelWidget(0, 0, this.getButtonWidth(BOptionHelper.ButtonType.NORMAL), 20, this.title));
        EditBox searchField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(GuiUtils.getTextRenderer(), 0, 20, (Component)Component.translatable((String)"screen.flatedit.selectblock.search")));
        searchField.setResponder(s -> {
            this.search = s;
            ((CustomConfigList)this.configList).clearEntries();
            this.addOptions();
        });
        searchField.setMaxLength(128);
        searchField.setWidth(250);
        title.addChild((LayoutElement)searchField);
    }

    protected void initFooter(LinearLayout layout) {
        layout.addChild((LayoutElement)this.createDoneButton(b -> this.onClose()));
        this.addRenderableWidget((GuiEventListener)new IconButton(3, 3, 24, 24, 16, 16, ResourceLocation.fromNamespaceAndPath((String)"boxhud", (String)"textures/icons/move.png"), b -> ClientUtils.setScreen((Screen)new WidgetPositionScreen((Screen)this))));
        this.addRenderableWidget((GuiEventListener)new IconButton(this.width - 27, 3, 24, 24, 16, 16, ResourceLocation.fromNamespaceAndPath((String)"boxhud", (String)"textures/icons/settings.png"), b -> ClientUtils.setScreen((Screen)new WidgetConfigScreen((Screen)this))));
    }

    protected void addOptions() {
        for (HudWidget.HudCategory category : HudWidget.HudCategory.values()) {
            List<WidgetEntry> widgets = BoxWidgets.widgetConfigs.values().stream().filter(e -> e.widget.getCategory() == category).filter(e -> e.getName().getString().toLowerCase().contains(this.search.toLowerCase())).toList();
            if (widgets.isEmpty()) continue;
            this.addConfigLine(new WidgetCategoryEntry((Component)Component.translatable((String)category.key)));
            widgets.forEach(w -> this.addConfigLine(new WidgetConfigEntry((WidgetEntry<?>)w)));
        }
    }

    public void onClose() {
        super.onClose();
        Boxhud.CONFIG.save();
        BoxWidgets.saveConfig(Boxhud.widgetConfigFile);
    }

    public static class CustomConfigList
    extends BConfigList {
        public CustomConfigList(Minecraft minecraft, BOptionScreen screen) {
            super(minecraft, screen);
        }

        public void clearEntries() {
            super.clearEntries();
        }
    }

    public class WidgetCategoryEntry
    extends BConfigList.ConfigEntry {
        Component title;

        public WidgetCategoryEntry(Component title) {
            this.title = title;
        }

        public List<? extends AbstractWidget> getWidgets() {
            return List.of();
        }

        public boolean isInvalid() {
            return false;
        }

        public void renderContent(GuiGraphics p_93523_, int i, int i1, boolean b, float v) {
            p_93523_.pose().pushMatrix();
            p_93523_.pose().scale(2.0f, 2.0f);
            p_93523_.drawCenteredString(GuiUtils.getTextRenderer(), this.title, WidgetListScreen.this.width / 4, this.getY() / 2 + this.getContentHeight() / 4, GuiUtils.WHITE);
            p_93523_.pose().popMatrix();
        }
    }

    public class WidgetConfigEntry
    extends BConfigList.ConfigEntry {
        BLabel title;
        BBooleanButton enabled;
        BScreenButton settings;
        WidgetEntry<?> entry;

        public WidgetConfigEntry(WidgetEntry<?> entry) {
            this.title = new BLabel(entry.getName());
            this.enabled = new BBooleanButton("boxhud.gui.widget.enabled", Boolean.valueOf(entry.enabled), v -> {
                entry.enabled = v;
            });
            this.settings = new BScreenButton((Component)Component.translatable((String)"boxhud.gui.widget.settings"), (Screen)WidgetListScreen.this, p -> entry.widget.getConfigScreen((Screen)WidgetListScreen.this, entry));
            this.entry = entry;
        }

        public List<? extends AbstractWidget> getWidgets() {
            return List.of(this.title, this.enabled, this.settings);
        }

        public boolean isInvalid() {
            return false;
        }

        private void renderWidget(GuiGraphics guiGraphics, int x, int y) {
            int maxHeight = WidgetListScreen.this.getRowHeight() - 10;
            int maxWidth = 100;
            RenderingLayout widg = this.entry.preRender(true);
            Rect rect = widg.calculateRect();
            float scale = (Integer)rect.getWidth() > (Integer)rect.getHeight() ? (float)maxWidth / (float)((Integer)rect.getWidth()).intValue() : (float)maxHeight / (float)((Integer)rect.getHeight()).intValue();
            if ((float)((Integer)rect.getHeight()).intValue() * scale > (float)maxHeight) {
                scale = (float)maxHeight / (float)((Integer)rect.getHeight()).intValue();
            }
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().scale(scale, scale);
            widg.setPosition((int)((float)(x += (int)(((float)maxWidth - (float)((Integer)rect.getWidth()).intValue() * scale) / 2.0f) + 5) / scale), (int)((float)(y += (int)(((float)WidgetListScreen.this.getRowHeight() - (float)((Integer)rect.getHeight()).intValue() * scale) / 2.0f - 2.0f)) / scale));
            RenderUtils.drawSquare((GuiGraphics)guiGraphics, (Rect)widg.calculateRect(), (int)Boxhud.getConfig().backgroundColor);
            widg.render(guiGraphics);
            guiGraphics.pose().popMatrix();
        }

        public void renderContent(GuiGraphics p_93523_, int i, int i1, boolean b, float v) {
            RenderUtils.drawSquare((GuiGraphics)p_93523_, (int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getContentHeight(), (int)1612652319);
            int color = -14737633;
            p_93523_.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + 1, color);
            p_93523_.fill(this.getX(), this.getY() + this.getContentHeight() - 1, this.getX() + this.getWidth(), this.getY() + this.getContentHeight(), color);
            p_93523_.fill(this.getX(), this.getY() + 1, this.getX() + 1, this.getY() + this.getContentHeight() - 1, color);
            p_93523_.fill(this.getX() + this.getWidth() - 1, this.getY() + 1, this.getX() + this.getWidth(), this.getY() + this.getContentHeight() - 1, color);
            this.renderWidget(p_93523_, this.getX(), this.getY());
            this.title.setX(this.getX() + 113);
            this.title.setY(this.getContentHeight() / 2 - this.title.getHeight() / 2 + this.getY());
            this.title.render(p_93523_, i, i1, v);
            this.enabled.setX(this.getWidth() / 5 * 3 - 7 + this.getX());
            this.enabled.setY(this.getContentHeight() / 2 - 10 + this.getY());
            this.enabled.setWidth(this.getWidth() / 5 + 6);
            this.enabled.render(p_93523_, i, i1, v);
            this.settings.setX(this.getWidth() / 5 * 4 + 2 + this.getX());
            this.settings.setY(this.getContentHeight() / 2 - 10 + this.getY());
            this.settings.setWidth(this.getWidth() / 5 - 4);
            this.settings.render(p_93523_, i, i1, v);
        }
    }
}

