/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.events;

import dev.boxadactle.boxhud.events.BoxHook;
import dev.boxadactle.boxhud.events.EntityAttackEvent;
import dev.boxadactle.boxhud.events.MouseEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class BoxEvents {
    public static final BoxHook<MouseEvent> CLICK_LEFT_MOUSE = BoxEvents.create(MouseEvent.class, listeners -> (action, mods) -> {
        for (MouseEvent listener : listeners) {
            listener.onClick(action, mods);
        }
    });
    public static final BoxHook<MouseEvent> CLICK_RIGHT_MOUSE = BoxEvents.create(MouseEvent.class, listeners -> (action, mods) -> {
        for (MouseEvent listener : listeners) {
            listener.onClick(action, mods);
        }
    });
    public static final BoxHook<EntityAttackEvent> ENTITY_ATTACK = BoxEvents.create(EntityAttackEvent.class, listeners -> target -> {
        for (EntityAttackEvent listener : listeners) {
            listener.onEntityAttack(target);
        }
    });

    public static <T> BoxHook<T> create(final Class<T> type, final InvokerFactory<T> invokerFactory) {
        return new BoxHook<T>(){
            private final List<T> listeners = new ArrayList();
            private T invoker = invokerFactory.create(this.listeners.toArray((Object[])Array.newInstance(type, 0)));

            @Override
            public void register(T listener) {
                this.listeners.add(listener);
                this.invoker = invokerFactory.create(this.listeners.toArray((Object[])Array.newInstance(type, 0)));
            }

            @Override
            public T invoker() {
                return this.invoker;
            }
        };
    }

    public static interface InvokerFactory<T> {
        public T create(T[] var1);
    }
}

