/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.neoforge.mixin;

import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class HotbarMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Shadow
    protected abstract void renderExperienceLevel(GuiGraphics var1, DeltaTracker var2);

    @Shadow
    protected abstract void renderHealthLevel(GuiGraphics var1);

    @Shadow
    protected abstract void renderArmorLevel(GuiGraphics var1);

    @Shadow
    protected abstract void renderFoodLevel(GuiGraphics var1);

    @Shadow
    protected abstract void renderVehicleHealth(GuiGraphics var1);

    @Shadow
    protected abstract void renderAirLevel(GuiGraphics var1);

    @Shadow
    protected abstract void maybeRenderSelectedItemName(GuiGraphics var1, DeltaTracker var2);

    @Shadow
    protected abstract void maybeRenderSpectatorTooltip(GuiGraphics var1, DeltaTracker var2);

    @Inject(method={"renderHotbar"}, at={@At(value="HEAD")})
    public void startTranslate(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)(-guiGraphics.guiWidth()) / 2.0f + 91.0f, (float)(-guiGraphics.guiHeight() + 60));
    }

    @Inject(method={"renderHotbar"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;renderItemHotbar(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V")})
    public void renderEverythingElse(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        if (this.minecraft.gameMode.canHurtPlayer()) {
            this.renderHealthLevel(guiGraphics);
            this.renderArmorLevel(guiGraphics);
            this.renderFoodLevel(guiGraphics);
            this.renderVehicleHealth(guiGraphics);
            this.renderAirLevel(guiGraphics);
        }
        this.renderExperienceLevel(guiGraphics, deltaTracker);
        this.maybeRenderSelectedItemName(guiGraphics, deltaTracker);
        this.maybeRenderSpectatorTooltip(guiGraphics, deltaTracker);
    }

    @Inject(method={"renderHotbar"}, at={@At(value="RETURN")})
    public void endTranslate(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        guiGraphics.pose().popMatrix();
    }
}

