/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.widget.general;

import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.PositionModifiers;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.util.ModUtil;
import dev.boxadactle.boxhud.widget.Widgets;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.TextComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.math.geometry.Vec3;
import dev.boxadactle.boxlib.util.RenderUtils;
import dev.boxadactle.boxlib.util.WorldUtils;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class CompassWidget
implements Widgets.General {
    public boolean renderXYZ = true;
    public boolean renderDistance = false;
    public boolean renderToWorldSpawn = false;

    @Override
    public String getNameKey() {
        return "compass";
    }

    public BlockPos resolveWorldSpawn() {
        try {
            if (this.renderToWorldSpawn) {
                return WorldUtils.getWorld().getRespawnData().globalPos().pos();
            }
            return WorldUtils.getWorld().getRespawnData().pos();
        }
        catch (Exception var2) {
            return new BlockPos(0, 0, 0);
        }
    }

    private ResourceLocation resolveCompassTexture(double d) {
        double degrees = Mth.wrapDegrees((double)(d + 180.0));
        double range360 = degrees + 180.0;
        double range1 = range360 / 360.0;
        String[] textures = new String[]{"compass_16", "compass_17", "compass_18", "compass_19", "compass_20", "compass_21", "compass_22", "compass_23", "compass_24", "compass_25", "compass_26", "compass_27", "compass_28", "compass_29", "compass_30", "compass_31", "compass_00", "compass_01", "compass_02", "compass_03", "compass_04", "compass_05", "compass_06", "compass_07", "compass_08", "compass_09", "compass_10", "compass_11", "compass_12", "compass_13", "compass_14", "compass_15", "compass_16"};
        String texture = "textures/item/" + textures[(int)(range1 * (double)textures.length)] + ".png";
        return ResourceLocation.withDefaultNamespace((String)texture);
    }

    public double calculateRelativeDirection(Vec3<Integer> pos1, Vec3<Integer> pos2, double yaw) {
        int x = (Integer)pos2.getX() - (Integer)pos1.getX();
        int z = (Integer)pos2.getZ() - (Integer)pos1.getZ();
        double theta = Math.atan2(z, x);
        double startDirection = Math.toDegrees(theta) + 180.0;
        double relativeDirection = startDirection - yaw;
        if (relativeDirection < 0.0) {
            relativeDirection += 360.0;
        }
        return Mth.wrapDegrees((double)((relativeDirection -= 180.0) - 90.0));
    }

    private RenderingLayout create(final boolean bl) {
        ColumnLayout columnLayout = new ColumnLayout(0, 0, 0);
        final BlockPos spawnPos = bl ? new BlockPos(102, 76, -89) : this.resolveWorldSpawn();
        columnLayout.addComponent((LayoutComponent)new LayoutComponent<Object>(null){

            public int getWidth() {
                return 32;
            }

            public int getHeight() {
                return 32;
            }

            public void render(GuiGraphics guiGraphics, int i, int i1) {
                Player p = WorldUtils.getPlayer();
                double degrees = bl ? 231.3 : CompassWidget.this.calculateRelativeDirection((Vec3<Integer>)new Vec3((Number)p.getBlockX(), (Number)p.getBlockY(), (Number)p.getBlockZ()), ModUtil.mcVecToVec(spawnPos), p.getYRot());
                RenderUtils.drawTexture((ResourceLocation)CompassWidget.this.resolveCompassTexture(degrees), (GuiGraphics)guiGraphics, (int)i, (int)i1, (int)32, (int)32, (int)0, (int)0);
            }
        });
        if (this.renderXYZ) {
            columnLayout.addComponent((LayoutComponent)new TextComponent(this.definition("xyz", this.value(Integer.toString(spawnPos.getX())), this.value(Integer.toString(spawnPos.getY())), this.value(Integer.toString(spawnPos.getZ())))));
        }
        if (this.renderDistance) {
            BlockPos playerPos = bl ? new BlockPos(1930, 75, 102) : WorldUtils.getPlayer().blockPosition();
            double distance = Math.sqrt(playerPos.distSqr((Vec3i)spawnPos));
            columnLayout.addComponent((LayoutComponent)new TextComponent(this.definition("distance", this.value(String.format("%.0fm", distance)))));
        }
        return columnLayout;
    }

    @Override
    public RenderingLayout createWidget(int x, int y) {
        return new PaddingLayout(x, y, this.padding(), this.create(false));
    }

    @Override
    public RenderingLayout createPlaceholderWidget(int x, int y) {
        return new PaddingLayout(x, y, this.padding(), this.create(true));
    }

    @Override
    public HudWidget.ConfigFactory<?> getConfigFactory() {
        return new HudWidget.ConfigFactory<CompassWidget>(this){

            @Override
            protected void addCustomConfigEntries(WidgetEntry<CompassWidget> entry, Consumer<BOptionEntry<?>> consumer) {
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.compass.renderXYZ", Boolean.valueOf(((CompassWidget)entry.widget).renderXYZ), value -> {
                    ((CompassWidget)entry.widget).renderXYZ = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.compass.renderDistance", Boolean.valueOf(((CompassWidget)entry.widget).renderDistance), value -> {
                    ((CompassWidget)entry.widget).renderDistance = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.compass.renderToWorldSpawn", Boolean.valueOf(((CompassWidget)entry.widget).renderToWorldSpawn), value -> {
                    ((CompassWidget)entry.widget).renderToWorldSpawn = value;
                }));
            }
        };
    }

    @Override
    public int getDefaultX() {
        return 5;
    }

    @Override
    public int getDefaultY() {
        return 0;
    }

    @Override
    public boolean defaultEnabled() {
        return false;
    }

    @Override
    public PositionModifiers getDefaultModifier() {
        return PositionModifiers.TOP_RIGHT;
    }
}

