/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.widget.general;

import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.PositionModifiers;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.util.InventoryUtils;
import dev.boxadactle.boxhud.widget.Widgets;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BColorPickerButton;
import dev.boxadactle.boxlib.gui.config.widget.slider.BIntegerSlider;
import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.TextComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ItemInfoWidget
implements Widgets.General {
    private final transient List<ItemChangeEntry> items = new ArrayList<ItemChangeEntry>();
    private transient List<ItemStack> previousItems = new ArrayList<ItemStack>();
    public int itemExpiry = 5;
    public int additionColor = GuiUtils.GREEN;
    public int removalColor = GuiUtils.RED;
    public int countColor = GuiUtils.WHITE;

    @Override
    public String getNameKey() {
        return "iteminfo";
    }

    private void addComponent(InventoryUtils.ItemChange change) {
        if (change.stack().isEmpty() || change.stack().is(Items.AIR)) {
            return;
        }
        ItemStack item = change.stack().copy();
        item.setCount(Math.abs(change.delta()));
        if (this.items.stream().anyMatch(entry -> entry.newItems(item, change.delta()))) {
            return;
        }
        this.items.add(new ItemChangeEntry(item, change.delta()));
        if (this.items.size() > 5) {
            this.items.removeFirst();
        }
    }

    private void update() {
        Player player = WorldUtils.getPlayer();
        if (player == null) {
            return;
        }
        List<ItemStack> current = InventoryUtils.getItemList(player);
        List<InventoryUtils.ItemChange> changes = InventoryUtils.compare(this.previousItems, current);
        changes.forEach(this::addComponent);
        this.previousItems = current;
    }

    @Override
    public void tick() {
        this.items.removeIf(item -> {
            item.tick();
            return item.despawn <= 0;
        });
    }

    private RenderingLayout widget(boolean isPlaceholder) {
        this.update();
        ColumnLayout layout = new ColumnLayout(0, 0, 3);
        if (!isPlaceholder) {
            for (int i = Math.max(0, this.items.size() - 5); i < this.items.size(); ++i) {
                layout.addComponent((LayoutComponent)new TextComponent(this.items.get(i).createComponent()));
            }
        } else {
            layout.addComponent((LayoutComponent)new TextComponent(new ItemChangeEntry(new ItemStack((ItemLike)Items.DIAMOND, 23), 23).createComponent()));
            layout.addComponent((LayoutComponent)new TextComponent(new ItemChangeEntry(new ItemStack((ItemLike)Items.GOLD_INGOT, 5), -5).createComponent()));
            layout.addComponent((LayoutComponent)new TextComponent(new ItemChangeEntry(new ItemStack((ItemLike)Items.IRON_INGOT, 10), 10).createComponent()));
            layout.addComponent((LayoutComponent)new TextComponent(new ItemChangeEntry(new ItemStack((ItemLike)Items.EMERALD, 2), -23).createComponent()));
            layout.addComponent((LayoutComponent)new TextComponent(new ItemChangeEntry(new ItemStack((ItemLike)Items.COAL, 15), 5).createComponent()));
        }
        return layout;
    }

    @Override
    public RenderingLayout createWidget(int x, int y) {
        return new PaddingLayout(x, y, this.padding(), this.widget(false));
    }

    @Override
    public RenderingLayout createPlaceholderWidget(int x, int y) {
        return new PaddingLayout(x, y, this.padding(), this.widget(true));
    }

    @Override
    public HudWidget.ConfigFactory<?> getConfigFactory() {
        return new HudWidget.ConfigFactory<ItemInfoWidget>(this){

            @Override
            protected void addCustomConfigEntries(WidgetEntry<ItemInfoWidget> entry, Consumer<BOptionEntry<?>> consumer) {
                consumer.accept((BOptionEntry<?>)new BIntegerSlider("boxhud.widget.iteminfo.itemExpiry", 0, 10, ((ItemInfoWidget)entry.widget).itemExpiry, value -> {
                    ((ItemInfoWidget)entry.widget).itemExpiry = value;
                }));
                consumer.accept((BOptionEntry<?>)new BColorPickerButton("boxhud.widget.iteminfo.additionColor", (Screen)this.screen, false, Integer.valueOf(((ItemInfoWidget)entry.widget).additionColor), c -> {
                    ((ItemInfoWidget)entry.widget).additionColor = c;
                }));
                consumer.accept((BOptionEntry<?>)new BColorPickerButton("boxhud.widget.iteminfo.removalColor", (Screen)this.screen, false, Integer.valueOf(((ItemInfoWidget)entry.widget).removalColor), c -> {
                    ((ItemInfoWidget)entry.widget).removalColor = c;
                }));
                consumer.accept((BOptionEntry<?>)new BColorPickerButton("boxhud.widget.iteminfo.countColor", (Screen)this.screen, false, Integer.valueOf(((ItemInfoWidget)entry.widget).countColor), c -> {
                    ((ItemInfoWidget)entry.widget).countColor = c;
                }));
            }
        };
    }

    @Override
    public int getDefaultX() {
        return 0;
    }

    @Override
    public int getDefaultY() {
        return 15;
    }

    @Override
    public boolean defaultEnabled() {
        return false;
    }

    @Override
    public PositionModifiers getDefaultModifier() {
        return PositionModifiers.BOTTOM_LEFT;
    }

    public class ItemChangeEntry {
        public final ItemStack item;
        public int count;
        public int despawn;

        public ItemChangeEntry(ItemStack item, int count) {
            this.despawn = ItemInfoWidget.this.itemExpiry * 20;
            this.item = item;
            this.count = count;
        }

        public void tick() {
            if (this.despawn > 0) {
                --this.despawn;
            }
        }

        public boolean newItems(ItemStack item, int change) {
            if (item.is(this.item.getItem())) {
                this.count += change;
                this.despawn = this.count != 0 ? ItemInfoWidget.this.itemExpiry * 20 : 0;
                return true;
            }
            return false;
        }

        public Component createComponent() {
            MutableComponent count = Component.literal((String)(Math.abs(this.count) + "x")).withColor(ItemInfoWidget.this.countColor);
            Component itemName = this.item.getHoverName();
            if (this.count > 0) {
                return ItemInfoWidget.this.translation("add", count, itemName.copy().withColor(ItemInfoWidget.this.additionColor)).copy().withColor(ItemInfoWidget.this.additionColor);
            }
            return ItemInfoWidget.this.translation("remove", count, itemName.copy().withColor(ItemInfoWidget.this.removalColor)).copy().withColor(ItemInfoWidget.this.removalColor);
        }
    }
}

