/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.widget.general;

import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.widget.Widgets;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.gui.config.widget.slider.BIntegerSlider;
import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.LayoutContainerComponent;
import dev.boxadactle.boxlib.layouts.component.TextComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.boxlib.util.ClientUtils;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ServerInfoWidget
implements Widgets.General {
    static final HashMap<String, FaviconTexture> serverIcons = new HashMap();
    static final ResourceLocation empty = ResourceLocation.withDefaultNamespace((String)"textures/misc/unknown_server.png");
    public boolean showIcon = true;
    public boolean showName = true;
    public int textPadding = 2;

    public Component getText(ServerData serverData) {
        if (ClientUtils.getClient().isSingleplayer()) {
            return this.definition("text", this.value("singleplayer"));
        }
        if (serverData == null) {
            return this.definition("text", this.value("noconnection"));
        }
        return this.definition("text", this.value(serverData.ip));
    }

    private ResourceLocation getIcon(ServerData serverData) {
        if (!ClientUtils.getClient().isSingleplayer() && serverData != null) {
            return serverIcons.computeIfAbsent(serverData.ip, a -> FaviconTexture.forServer((TextureManager)ClientUtils.getClient().getTextureManager(), (String)serverData.ip)).textureLocation();
        }
        return empty;
    }

    public RenderingLayout create(final ServerData data) {
        RowLayout layout = new RowLayout(0, 0, this.textPadding);
        if (this.showIcon) {
            final int size = 24;
            layout.addComponent((LayoutComponent)new LayoutComponent<Object>(null){

                public int getWidth() {
                    return size;
                }

                public int getHeight() {
                    return size;
                }

                public void render(GuiGraphics guiGraphics, int i, int i1) {
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ServerInfoWidget.this.getIcon(data), i, i1, 0.0f, 0.0f, size, size, size, size);
                }
            });
        }
        ColumnLayout text = new ColumnLayout(0, 0, this.textPadding);
        if (this.showName) {
            if (data != null) {
                text.addComponent((LayoutComponent)new TextComponent(this.definition((Component)Component.literal((String)data.name))));
            } else {
                text.addComponent((LayoutComponent)new TextComponent(this.definition("unknown", new Object[0])));
            }
        }
        text.addComponent((LayoutComponent)new TextComponent(this.value(this.getText(data))));
        layout.addComponent((LayoutComponent)new LayoutContainerComponent((RenderingLayout)text));
        return layout;
    }

    @Override
    public String getNameKey() {
        return "serverinfo";
    }

    @Override
    public HudWidget.ConfigFactory<?> getConfigFactory() {
        return new HudWidget.ConfigFactory<ServerInfoWidget>(this){

            @Override
            protected void addCustomConfigEntries(WidgetEntry<ServerInfoWidget> entry, Consumer<BOptionEntry<?>> consumer) {
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.serverinfo.showIcon", Boolean.valueOf(((ServerInfoWidget)entry.widget).showIcon), value -> {
                    ((ServerInfoWidget)entry.widget).showIcon = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.serverinfo.showName", Boolean.valueOf(((ServerInfoWidget)entry.widget).showName), value -> {
                    ((ServerInfoWidget)entry.widget).showName = value;
                }));
                consumer.accept((BOptionEntry<?>)new BIntegerSlider("boxhud.gui.widget.textPadding", 0, 10, ((ServerInfoWidget)entry.widget).textPadding, value -> {
                    ((ServerInfoWidget)entry.widget).textPadding = value;
                }));
            }
        };
    }

    @Override
    public RenderingLayout createWidget(int x, int y) {
        return new PaddingLayout(x, y, this.padding(), this.create(ClientUtils.getClient().getCurrentServer()));
    }

    @Override
    public RenderingLayout createPlaceholderWidget(int x, int y) {
        return new PaddingLayout(x, y, this.padding(), this.create(null));
    }

    @Override
    public int getDefaultX() {
        return 0;
    }

    @Override
    public int getDefaultY() {
        return 30;
    }

    @Override
    public boolean defaultEnabled() {
        return false;
    }
}

