/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.widget.general;

import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.util.ModUtil;
import dev.boxadactle.boxhud.widget.Widgets;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.TextComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.PaddingLayout;
import dev.boxadactle.boxlib.util.WorldUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TimeWidget
implements Widgets.General {
    public boolean showGameClock = true;
    public boolean showGameTime = true;
    public boolean showRealTime = false;
    public boolean twentyFourHourFormat = true;

    @Override
    public String getNameKey() {
        return "time";
    }

    private RenderingLayout create(boolean bl) {
        String timeStamp;
        ColumnLayout columnLayout = new ColumnLayout(0, 0, 0);
        if (this.showGameClock) {
            columnLayout.addComponent((LayoutComponent)new LayoutComponent<Object>(this, null){

                public int getWidth() {
                    return 32;
                }

                public int getHeight() {
                    return 32;
                }

                public void render(GuiGraphics guiGraphics, int i, int i1) {
                    guiGraphics.pose().pushMatrix();
                    guiGraphics.pose().scale(2.0f, 2.0f);
                    guiGraphics.renderItem(new ItemStack((ItemLike)Items.CLOCK), i / 2, i1 / 2);
                    guiGraphics.pose().popMatrix();
                }
            });
        }
        if (this.showGameTime) {
            long timestamp = bl ? WorldUtils.getWorld().getDayTime() % 24000L : 16372L;
            int hours = (int)(timestamp / 1000L + 6L) % 24;
            int minutes = (int)((double)(timestamp % 1000L) / 1000.0 * 60.0);
            timeStamp = this.twentyFourHourFormat ? ModUtil.formatDate24h(hours, minutes) : ModUtil.formatDate12h(hours, minutes);
            columnLayout.addComponent((LayoutComponent)new TextComponent(this.definition("game", this.value(timeStamp))));
        }
        if (this.showRealTime) {
            long currentTimeMillis = System.currentTimeMillis();
            Date date = new Date(currentTimeMillis);
            SimpleDateFormat sdf = this.twentyFourHourFormat ? new SimpleDateFormat("HH:mm") : new SimpleDateFormat("hh:mm a");
            timeStamp = sdf.format(date);
            columnLayout.addComponent((LayoutComponent)new TextComponent(this.definition("real", this.value(timeStamp))));
        }
        return columnLayout;
    }

    @Override
    public HudWidget.ConfigFactory<?> getConfigFactory() {
        return new HudWidget.ConfigFactory<TimeWidget>(this){

            @Override
            protected void addCustomConfigEntries(WidgetEntry<TimeWidget> entry, Consumer<BOptionEntry<?>> consumer) {
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.time.showGameClock", Boolean.valueOf(((TimeWidget)entry.widget).showGameClock), value -> {
                    ((TimeWidget)entry.widget).showGameClock = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.time.showGameTime", Boolean.valueOf(((TimeWidget)entry.widget).showGameTime), value -> {
                    ((TimeWidget)entry.widget).showGameTime = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.time.showRealTime", Boolean.valueOf(((TimeWidget)entry.widget).showRealTime), value -> {
                    ((TimeWidget)entry.widget).showRealTime = value;
                }));
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.time.twentyFourHourFormat", Boolean.valueOf(((TimeWidget)entry.widget).twentyFourHourFormat), value -> {
                    ((TimeWidget)entry.widget).twentyFourHourFormat = value;
                }));
            }
        };
    }

    @Override
    public RenderingLayout createWidget(int x, int y) {
        return new PaddingLayout(x, y, this.padding(), this.create(true));
    }

    @Override
    public RenderingLayout createPlaceholderWidget(int x, int y) {
        return new PaddingLayout(x, y, this.padding(), this.create(false));
    }

    @Override
    public int getDefaultX() {
        return 0;
    }

    @Override
    public int getDefaultY() {
        return 0;
    }

    @Override
    public boolean defaultEnabled() {
        return false;
    }
}

