/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxhud.widget.pvp;

import dev.boxadactle.boxhud.HudWidget;
import dev.boxadactle.boxhud.PositionModifiers;
import dev.boxadactle.boxhud.WidgetEntry;
import dev.boxadactle.boxhud.widget.SimpleTextWidget;
import dev.boxadactle.boxhud.widget.Widgets;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.gui.config.widget.slider.BIntegerSlider;
import dev.boxadactle.boxlib.math.mathutils.NumberFormatter;
import dev.boxadactle.boxlib.util.WorldUtils;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class SpeedWidget
implements Widgets.Pvp,
SimpleTextWidget {
    public boolean showHorizonalVelocity = true;
    public int decimalPlaces = 2;
    transient NumberFormatter<Double> formatter;

    @Override
    public void init() {
        this.formatter = new NumberFormatter(this.decimalPlaces);
    }

    @Override
    public Component getText() {
        Player entity = WorldUtils.getPlayer().getVehicle() != null ? WorldUtils.getPlayer().getVehicle() : WorldUtils.getPlayer();
        Vec3 vec = entity.getDeltaMovement();
        if (entity.onGround() && vec.y < 0.0) {
            vec = new Vec3(vec.x, 0.0, vec.z);
        }
        double speed = this.showHorizonalVelocity ? vec.horizontalDistance() : vec.length();
        return this.definition("text", this.value(this.formatter.formatDecimal((Number)(speed * 20.0))));
    }

    @Override
    public Component getPlaceholderText() {
        return this.definition("text", this.value(this.formatter.formatDecimal((Number)0.0)));
    }

    public HudWidget.ConfigFactory<SpeedWidget> getConfigFactory() {
        return new HudWidget.ConfigFactory<SpeedWidget>(this){

            @Override
            protected void addCustomConfigEntries(WidgetEntry<SpeedWidget> entry, Consumer<BOptionEntry<?>> consumer) {
                consumer.accept((BOptionEntry<?>)new BBooleanButton("boxhud.widget.speed.showHorizontalVelocity", Boolean.valueOf(((SpeedWidget)entry.widget).showHorizonalVelocity), value -> {
                    ((SpeedWidget)entry.widget).showHorizonalVelocity = value;
                }));
                consumer.accept((BOptionEntry<?>)new BIntegerSlider("boxhud.widget.speed.decimalPlaces", 0, 5, ((SpeedWidget)entry.widget).decimalPlaces, value -> {
                    ((SpeedWidget)entry.widget).decimalPlaces = value;
                    ((SpeedWidget)entry.widget).formatter = new NumberFormatter(value.intValue());
                }));
            }
        };
    }

    @Override
    public String getNameKey() {
        return "speed";
    }

    @Override
    public int getDefaultX() {
        return 0;
    }

    @Override
    public int getDefaultY() {
        return 50;
    }

    @Override
    public PositionModifiers getDefaultModifier() {
        return PositionModifiers.BOTTOM_LEFT;
    }

    @Override
    public boolean defaultEnabled() {
        return false;
    }
}

