/*
 * Decompiled with CFR 0.152.
 */
package leaf.satisfactory.dimensionaldepot;

import com.mojang.logging.LogUtils;
import leaf.satisfactory.dimensionaldepot.common.Config;
import leaf.satisfactory.dimensionaldepot.common.network.PacketHandler;
import leaf.satisfactory.dimensionaldepot.common.registries.AttachmentRegistry;
import leaf.satisfactory.dimensionaldepot.common.registries.BlocksRegistry;
import leaf.satisfactory.dimensionaldepot.common.registries.CreativeTabRegistry;
import leaf.satisfactory.dimensionaldepot.common.registries.ItemsRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.slf4j.Logger;

@Mod(value="dimensionaldepot")
public class DimensionalDepot {
    public static final String MODID = "dimensionaldepot";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static DimensionalDepot instance;
    private final PacketHandler packetHandler;

    public DimensionalDepot(IEventBus modEventBus, ModContainer modContainer) {
        instance = this;
        modEventBus.addListener(this::commonSetup);
        BlocksRegistry.BLOCKS.register(modEventBus);
        ItemsRegistry.ITEMS.register(modEventBus);
        CreativeTabRegistry.CREATIVE_MODE_TABS.register(modEventBus);
        AttachmentRegistry.ATTACHMENT_TYPES.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        this.packetHandler = new PacketHandler(modEventBus, "1.0.0");
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        if (Config.logDirtBlock) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)BuiltInRegistries.BLOCK.getKey((Object)Blocks.DIRT));
        }
        LOGGER.info(Config.magicNumberIntroduction + Config.magicNumber);
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("The boot process was very satisfactory");
    }

    @SubscribeEvent
    private void serverStopped(ServerStoppedEvent event) {
    }

    private void onWorldLoad(LevelEvent.Load event) {
    }

    public static PacketHandler packetHandler() {
        return DimensionalDepot.instance.packetHandler;
    }
}

