/*
 * Decompiled with CFR 0.152.
 */
package leaf.satisfactory.dimensionaldepot.client.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import leaf.satisfactory.dimensionaldepot.client.gui.DepotItemButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DepotBookPage {
    public static final int ITEMS_PER_PAGE = 20;
    private static final WidgetSprites PAGE_FORWARD_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/page_forward"), ResourceLocation.withDefaultNamespace((String)"recipe_book/page_forward_highlighted"));
    private static final WidgetSprites PAGE_BACKWARD_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/page_backward"), ResourceLocation.withDefaultNamespace((String)"recipe_book/page_backward_highlighted"));
    private final List<DepotItemButton> buttons = Lists.newArrayListWithCapacity((int)20);
    @Nullable
    private DepotItemButton hoveredButton;
    private Minecraft minecraft;
    private List<ItemStack> itemStacks = ImmutableList.of();
    private StateSwitchingButton forwardButton;
    private StateSwitchingButton backButton;
    private int totalPages;
    private int currentPage;
    private ItemStack lastClickedItemStack;

    public DepotBookPage() {
        for (int i = 0; i < 20; ++i) {
            this.buttons.add(new DepotItemButton());
        }
    }

    public void init(Minecraft pMinecraft, int pX, int pY) {
        this.minecraft = pMinecraft;
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).setPosition(pX + 11 + 25 * (i % 5), pY + 31 + 25 * (i / 5));
        }
        this.forwardButton = new StateSwitchingButton(pX + 93, pY + 137, 12, 17, false);
        this.forwardButton.initTextureValues(PAGE_FORWARD_SPRITES);
        this.backButton = new StateSwitchingButton(pX + 38, pY + 137, 12, 17, true);
        this.backButton.initTextureValues(PAGE_BACKWARD_SPRITES);
    }

    public void updateCollections(List<ItemStack> itemStacks, boolean pResetPageNumber) {
        this.itemStacks = itemStacks;
        this.totalPages = (int)Math.ceil((double)itemStacks.size() / 20.0);
        if (this.totalPages <= this.currentPage || pResetPageNumber) {
            this.currentPage = 0;
        }
        this.updateButtonsForPage();
    }

    private void updateButtonsForPage() {
        int i = 20 * this.currentPage;
        for (int j = 0; j < this.buttons.size(); ++j) {
            DepotItemButton depotItemButton = this.buttons.get(j);
            if (i + j < this.itemStacks.size()) {
                ItemStack stack = this.itemStacks.get(i + j);
                depotItemButton.init(stack, this);
                depotItemButton.visible = true;
                continue;
            }
            depotItemButton.visible = false;
        }
        this.updateArrowButtons();
    }

    private void updateArrowButtons() {
        this.forwardButton.visible = this.totalPages > 1 && this.currentPage < this.totalPages - 1;
        this.backButton.visible = this.totalPages > 1 && this.currentPage > 0;
    }

    public void render(GuiGraphics pGuiGraphics, int pX, int pY, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.totalPages > 1) {
            MutableComponent component = Component.translatable((String)"gui.recipebook.page", (Object[])new Object[]{this.currentPage + 1, this.totalPages});
            int i = this.minecraft.font.width((FormattedText)component);
            pGuiGraphics.drawString(this.minecraft.font, (Component)component, pX - i / 2 + 73, pY + 141, -1, false);
        }
        this.hoveredButton = null;
        for (DepotItemButton depotItemButton : this.buttons) {
            depotItemButton.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
            if (!depotItemButton.visible || !depotItemButton.isHoveredOrFocused()) continue;
            this.hoveredButton = depotItemButton;
        }
        this.backButton.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.forwardButton.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        if (this.minecraft.screen != null && this.hoveredButton != null) {
            pGuiGraphics.renderComponentTooltip(this.minecraft.font, this.hoveredButton.getTooltipText(), pX, pY);
        }
    }

    public void setInvisible() {
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton, int startingX, int startingY, int imageWidth, int imageHeight) {
        this.lastClickedItemStack = null;
        if (this.forwardButton.mouseClicked(pMouseX, pMouseY, pButton)) {
            ++this.currentPage;
            this.updateButtonsForPage();
            return true;
        }
        if (this.backButton.mouseClicked(pMouseX, pMouseY, pButton)) {
            --this.currentPage;
            this.updateButtonsForPage();
            return true;
        }
        for (DepotItemButton depotItemButton : this.buttons) {
            if (!depotItemButton.mouseClicked(pMouseX, pMouseY, pButton)) continue;
            this.lastClickedItemStack = depotItemButton.getItemStack();
            return true;
        }
        return false;
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    protected void listButtons(Consumer<AbstractWidget> pConsumer) {
        pConsumer.accept((AbstractWidget)this.forwardButton);
        pConsumer.accept((AbstractWidget)this.backButton);
        this.buttons.forEach(pConsumer);
    }

    public ItemStack getLastClickedItemStack() {
        return this.lastClickedItemStack;
    }

    public boolean mouseScrolled(double pScrollY) {
        if (pScrollY > 0.0) {
            if (this.backButton.visible) {
                --this.currentPage;
                this.updateButtonsForPage();
                return true;
            }
        } else if (pScrollY < 0.0 && this.forwardButton.visible) {
            ++this.currentPage;
            this.updateButtonsForPage();
            return true;
        }
        return false;
    }
}

