/*
 * Decompiled with CFR 0.152.
 */
package leaf.satisfactory.dimensionaldepot.client.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import leaf.satisfactory.dimensionaldepot.client.gui.DepotBookPage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DepotItemButton
extends AbstractWidget {
    private static final ResourceLocation SLOT_MANY_CRAFTABLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"recipe_book/slot_many_craftable");
    private static final ResourceLocation SLOT_CRAFTABLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"recipe_book/slot_craftable");
    private static final ResourceLocation SLOT_MANY_UNCRAFTABLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"recipe_book/slot_many_uncraftable");
    private static final ResourceLocation SLOT_UNCRAFTABLE_SPRITE = ResourceLocation.withDefaultNamespace((String)"recipe_book/slot_uncraftable");
    private static final float ANIMATION_TIME = 15.0f;
    private static final int BACKGROUND_SIZE = 25;
    public static final int TICKS_TO_SWAP = 30;
    private static final Component MORE_RECIPES_TOOLTIP = Component.translatable((String)"gui.recipebook.moreRecipes");
    private RecipeBookMenu<?, ?> menu;
    private ItemStack itemStack;
    private float time;
    private float animationTime;
    private int currentIndex;

    public DepotItemButton() {
        super(0, 0, 25, 25, CommonComponents.EMPTY);
    }

    public void init(ItemStack stack, DepotBookPage depotBookPage) {
        this.itemStack = stack;
        this.menu = (RecipeBookMenu)depotBookPage.getMinecraft().player.containerMenu;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        boolean isAnimating;
        if (!Screen.hasControlDown()) {
            this.time += pPartialTick;
        }
        ResourceLocation backgroundSpriteRL = this.itemStack != null && this.itemStack.getCount() > 1 ? SLOT_CRAFTABLE_SPRITE : SLOT_UNCRAFTABLE_SPRITE;
        boolean bl = isAnimating = this.animationTime > 0.0f;
        if (isAnimating) {
            float f = 1.0f + 0.1f * (float)Math.sin(this.animationTime / 15.0f * (float)Math.PI);
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate((float)(this.getX() + 8), (float)(this.getY() + 12), 0.0f);
            pGuiGraphics.pose().scale(f, f, 1.0f);
            pGuiGraphics.pose().translate((float)(-(this.getX() + 8)), (float)(-(this.getY() + 12)), 0.0f);
            this.animationTime -= pPartialTick;
        }
        pGuiGraphics.blitSprite(backgroundSpriteRL, this.getX(), this.getY(), this.width, this.height);
        ItemStack itemstack = this.itemStack;
        int i = 4;
        int j = this.getX() + i;
        int k = this.getY() + i;
        pGuiGraphics.renderItem(itemstack, j, k);
        pGuiGraphics.renderItemDecorations(Minecraft.getInstance().font, itemstack, j, k);
        if (isAnimating) {
            pGuiGraphics.pose().popPose();
        }
    }

    public List<Component> getTooltipText() {
        ItemStack itemstack = this.itemStack;
        ArrayList list = Lists.newArrayList((Iterable)Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)itemstack));
        return list;
    }

    public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
        ItemStack itemstack = this.itemStack;
        pNarrationElementOutput.add(NarratedElementType.TITLE, itemstack.getHoverName());
        pNarrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.button.usage.hovered"));
    }

    public int getWidth() {
        return 25;
    }

    protected boolean isValidClickButton(int pButton) {
        return pButton == 0 || pButton == 1;
    }
}

