/*
 * Decompiled with CFR 0.152.
 */
package leaf.satisfactory.dimensionaldepot.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import leaf.satisfactory.dimensionaldepot.DimensionalDepot;
import leaf.satisfactory.dimensionaldepot.client.gui.DepotBookPage;
import leaf.satisfactory.dimensionaldepot.common.DimensionalDepotCap;
import leaf.satisfactory.dimensionaldepot.common.DimensionalDepotLocalSettings;
import leaf.satisfactory.dimensionaldepot.common.events.EventsGame;
import leaf.satisfactory.dimensionaldepot.common.network.PacketUtils;
import leaf.satisfactory.dimensionaldepot.common.network.to_server.take_from_cloud.ClickUploadSlotPacket;
import leaf.satisfactory.dimensionaldepot.common.network.to_server.take_from_cloud.DownloadItemPacket;
import leaf.satisfactory.dimensionaldepot.mixin.AbstractContainerScreenAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookTabButton;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.ScreenEvent;

@OnlyIn(value=Dist.CLIENT)
public class DimensionalDepotComponent
implements Renderable,
GuiEventListener {
    public static final WidgetSprites RECIPE_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/button"), ResourceLocation.withDefaultNamespace((String)"recipe_book/button_highlighted"));
    private static final WidgetSprites FILTER_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_enabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_disabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_enabled_highlighted"), ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_disabled_highlighted"));
    protected static final ResourceLocation RECIPE_BOOK_IMG = DimensionalDepot.rl("textures/gui/depot_background.png");
    private static final Component SEARCH_HINT = Component.translatable((String)"gui.recipebook.search_hint").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    public static final int IMAGE_WIDTH = 147;
    public static final int IMAGE_HEIGHT = 166;
    private static final int OFFSET_X_POSITION = 86;
    private static final Component CRAFT_FROM_DEPOT_TOOLTIP = Component.translatable((String)"gui.depot.toggle.craft_from_depot");
    private static final Component DONT_CRAFT_FROM_DEPOT_TOOLTIP = Component.translatable((String)"gui.depot.toggle.dont_craft_from_depot");
    private int xOffset;
    private int screenWidth;
    private int screenHeight;
    private final List<RecipeBookTabButton> tabButtons = Lists.newArrayList();
    @Nullable
    private RecipeBookTabButton selectedTab;
    protected StateSwitchingButton filterButton;
    protected RecipeBookMenu<?, ?> menu;
    protected Minecraft minecraft;
    @Nullable
    private EditBox searchBox;
    private String lastSearch = "";
    private ClientRecipeBook book;
    private final DepotBookPage depotBookPage = new DepotBookPage();
    private final SimpleContainer uploadQueueInventory = new SimpleContainer(5);
    public final NonNullList<Slot> uploadSlots = NonNullList.create();
    private final StackedContents stackedContents = new StackedContents();
    private int timesInventoryChanged;
    private boolean ignoreTextInput;
    private boolean visible;
    private boolean widthTooNarrow;
    List<ItemStack> depotStackCache = new LinkedList<ItemStack>();
    private LocalPlayer player;
    private AbstractContainerScreen<?> screen;
    private static boolean isLeftMouseDown;
    private static boolean ignoreMouseUp;

    public void init(int screenWidth, int screenHeight, Minecraft pMinecraft, boolean pWidthTooNarrow, AbstractContainerScreen<?> screen, RecipeBookMenu<?, ?> pMenu) {
        this.minecraft = pMinecraft;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.menu = pMenu;
        this.screen = screen;
        this.widthTooNarrow = pWidthTooNarrow;
        this.player = pMinecraft.player;
        this.player.containerMenu = pMenu;
        this.book = this.player.getRecipeBook();
        this.timesInventoryChanged = this.player.getInventory().getTimesChanged();
        this.visible = this.shouldShowComponent();
        if (this.visible) {
            this.initVisuals();
        }
        int startingX = this.getStartingX();
        int startingY = this.getStartingY();
        for (int uploadSlotIndex = 0; uploadSlotIndex < 5; ++uploadSlotIndex) {
            this.addSlot(new Slot((Container)this.uploadQueueInventory, uploadSlotIndex, startingX + uploadSlotIndex * 18 + 8, startingY + 166 + 1));
        }
    }

    protected Slot addSlot(Slot pSlot) {
        pSlot.index = this.uploadSlots.size();
        this.uploadSlots.add((Object)pSlot);
        return pSlot;
    }

    public void initVisuals() {
        this.xOffset = this.widthTooNarrow ? 0 : 86;
        int x = this.getStartingX();
        int y = this.getStartingY();
        this.stackedContents.clear();
        this.minecraft.player.getInventory().fillStackedContents(this.stackedContents);
        this.menu.fillCraftSlotsStackedContents(this.stackedContents);
        String s = this.searchBox != null ? this.searchBox.getValue() : "";
        this.searchBox = new EditBox(this.minecraft.font, x + 25, y + 13, 81, 14, (Component)Component.translatable((String)"itemGroup.search"));
        this.searchBox.setMaxLength(50);
        this.searchBox.setVisible(true);
        this.searchBox.setTextColor(0xFFFFFF);
        this.searchBox.setValue(s);
        this.searchBox.setHint(SEARCH_HINT);
        this.depotBookPage.init(this.minecraft, x, y);
        this.filterButton = new StateSwitchingButton(x + 110, y + 12, 26, 16, DimensionalDepotLocalSettings.getInstance().getCraftFromDepotState());
        this.updateFilterButtonTooltip();
        this.initFilterButtonTextures();
        this.tabButtons.clear();
        this.updateCollections(false);
    }

    private int getStartingX() {
        return this.screenWidth / 2 - 147 - this.xOffset;
    }

    private int getStartingY() {
        return (this.screenHeight - 166) / 2;
    }

    private void updateFilterButtonTooltip() {
        this.filterButton.setTooltip(this.filterButton.isStateTriggered() ? Tooltip.create((Component)this.getRecipeFilterName()) : Tooltip.create((Component)DONT_CRAFT_FROM_DEPOT_TOOLTIP));
    }

    protected void initFilterButtonTextures() {
        this.filterButton.initTextureValues(FILTER_BUTTON_SPRITES);
    }

    public boolean isVisible() {
        return this.visible;
    }

    private boolean shouldShowComponent() {
        DimensionalDepotCap capability = (DimensionalDepotCap)this.player.getCapability(EventsGame.DEPOT);
        if (capability != null && capability.getSpeedTier() <= 0) {
            return false;
        }
        return !this.book.isOpen(this.menu.getRecipeBookType());
    }

    protected void setVisible(boolean pVisible) {
        if (pVisible) {
            this.initVisuals();
        }
        this.visible = pVisible;
        if (!pVisible) {
            // empty if block
        }
    }

    public void slotClicked(@Nullable Slot pSlot) {
        if (pSlot != null && pSlot.index < this.menu.getSize() && this.isVisible()) {
            this.updateStackedContents();
        }
    }

    private void updateCollections(boolean pResetPageNumber) {
        String s;
        this.depotStackCache.clear();
        DimensionalDepotCap depot = (DimensionalDepotCap)this.player.getCapability(EventsGame.DEPOT);
        if (depot != null) {
            int i;
            for (i = 0; i < depot.getSlots(); ++i) {
                ItemStack stack2 = depot.getStackInSlot(i);
                if (stack2.isEmpty()) continue;
                this.depotStackCache.add(stack2.copy());
            }
            for (i = 0; i < this.uploadQueueInventory.getContainerSize(); ++i) {
                this.uploadQueueInventory.setItem(i, depot.getUploadQueue().getStackInSlot(i).copy());
            }
        }
        if (!(s = this.searchBox.getValue()).isEmpty()) {
            String searchString = s.toLowerCase(Locale.ROOT);
            this.depotStackCache.removeIf(stack -> !stack.getDisplayName().getString().toLowerCase(Locale.ROOT).contains(searchString));
        }
        this.depotBookPage.updateCollections(this.depotStackCache, pResetPageNumber);
    }

    public void tick() {
        boolean shouldShowComponent = this.shouldShowComponent();
        if (this.isVisible() != shouldShowComponent) {
            this.setVisible(shouldShowComponent);
        }
        if (this.isVisible() && this.timesInventoryChanged != this.minecraft.player.getInventory().getTimesChanged()) {
            this.updateStackedContents();
            this.timesInventoryChanged = this.minecraft.player.getInventory().getTimesChanged();
        }
    }

    private void updateStackedContents() {
        this.stackedContents.clear();
        this.minecraft.player.getInventory().fillStackedContents(this.stackedContents);
        this.menu.fillCraftSlotsStackedContents(this.stackedContents);
        this.updateCollections(false);
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.tick();
        if (this.isVisible()) {
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            int startingX = this.getStartingX();
            int startingY = this.getStartingY();
            pGuiGraphics.blit(RECIPE_BOOK_IMG, startingX, startingY, 1, 1, 147, 191);
            this.searchBox.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
            this.filterButton.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
            this.depotBookPage.render(pGuiGraphics, startingX, startingY, pMouseX, pMouseY, pPartialTick);
            RenderSystem.enableBlend();
            for (Slot slot : this.uploadSlots) {
                ItemStack itemstack = slot.getItem();
                pGuiGraphics.renderItem(itemstack, slot.x, slot.y);
                pGuiGraphics.renderItemDecorations(this.minecraft.font, itemstack, slot.x, slot.y);
                if (!this.isHovering(slot, pMouseX, pMouseY)) continue;
                AbstractContainerScreen.renderSlotHighlight((GuiGraphics)pGuiGraphics, (int)slot.x, (int)slot.y, (int)0);
            }
            RenderSystem.disableBlend();
            pGuiGraphics.pose().popPose();
            this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        }
    }

    private boolean isHovering(Slot pSlot, double pMouseX, double pMouseY) {
        return this.isHovering(pSlot.x, pSlot.y, 16, 16, pMouseX, pMouseY);
    }

    protected boolean isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        return pMouseX >= (double)(pX - 1) && pMouseX < (double)(pX + pWidth + 1) && pMouseY >= (double)(pY - 1) && pMouseY < (double)(pY + pHeight + 1);
    }

    public void renderTooltip(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        if (this.isVisible()) {
            this.depotBookPage.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
            this.renderUploadQueueTooltip(pGuiGraphics, pMouseX, pMouseY);
        }
    }

    private void renderUploadQueueTooltip(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        for (Slot slot : this.uploadSlots) {
            ItemStack itemstack;
            if (!((AbstractContainerScreenAccessor)this.screen).callIsHovering(slot, pMouseX, pMouseY) || (itemstack = slot.getItem()).isEmpty()) continue;
            pGuiGraphics.renderTooltip(this.minecraft.font, itemstack.getHoverName(), pMouseX, pMouseY);
        }
    }

    protected Component getRecipeFilterName() {
        return CRAFT_FROM_DEPOT_TOOLTIP;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.isVisible() && !this.minecraft.player.isSpectator() && this.isHovering(this.getStartingX(), this.getStartingY(), 147, 166, pMouseX, pMouseY)) {
            return this.depotBookPage.mouseScrolled(pScrollY);
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.isVisible() && !this.minecraft.player.isSpectator()) {
            if (this.depotBookPage.mouseClicked(pMouseX, pMouseY, pButton, this.getStartingX(), this.getStartingY(), 147, 166)) {
                ItemStack stack = this.depotBookPage.getLastClickedItemStack();
                if (stack != null && !stack.isEmpty()) {
                    DownloadItemPacket dataPayload = new DownloadItemPacket(Screen.hasShiftDown(), pButton, stack);
                    PacketUtils.sendToServer(dataPayload);
                    ignoreMouseUp = true;
                    if (!this.isOffsetNextToMainGUI()) {
                        this.setVisible(false);
                    }
                }
                return true;
            }
            if (this.searchBox.mouseClicked(pMouseX, pMouseY, pButton)) {
                this.searchBox.setFocused(true);
                return true;
            }
            this.searchBox.setFocused(false);
            if (this.filterButton.mouseClicked(pMouseX, pMouseY, pButton)) {
                boolean flag = this.toggleFiltering();
                this.filterButton.setStateTriggered(flag);
                this.updateFilterButtonTooltip();
                this.updateCollections(false);
                return true;
            }
            for (RecipeBookTabButton recipebooktabbutton : this.tabButtons) {
                if (!recipebooktabbutton.mouseClicked(pMouseX, pMouseY, pButton)) continue;
                if (this.selectedTab != recipebooktabbutton) {
                    if (this.selectedTab != null) {
                        this.selectedTab.setStateTriggered(false);
                    }
                    this.selectedTab = recipebooktabbutton;
                    this.selectedTab.setStateTriggered(true);
                    this.updateCollections(true);
                }
                return true;
            }
            for (Slot slot : this.uploadSlots) {
                if (!this.isHovering(slot, pMouseX, pMouseY)) continue;
                DimensionalDepotCap depotCap = (DimensionalDepotCap)this.player.getCapability(EventsGame.DEPOT);
                if (depotCap != null) break;
            }
            return false;
        }
        return false;
    }

    public void onMouseReleased(ScreenEvent.MouseButtonReleased.Pre event) {
        if (event.getButton() == 0) {
            isLeftMouseDown = false;
        }
        if (ignoreMouseUp) {
            event.setCanceled(true);
            ignoreMouseUp = false;
        }
    }

    public void onMousePressed(ScreenEvent.MouseButtonPressed.Pre event) {
        if (event.getButton() == 0) {
            isLeftMouseDown = true;
        }
        double mouseX = event.getMouseX();
        double mouseY = event.getMouseY();
        for (Slot slot : this.uploadSlots) {
            if (!this.isHovering(slot, mouseX, mouseY)) continue;
            DimensionalDepotCap depotCap = (DimensionalDepotCap)this.player.getCapability(EventsGame.DEPOT);
            if (depotCap != null) {
                PacketUtils.sendToServer(new ClickUploadSlotPacket(Screen.hasShiftDown(), event.getButton(), slot.index));
            }
            event.setCanceled(true);
            ignoreMouseUp = true;
            return;
        }
    }

    private boolean toggleFiltering() {
        DimensionalDepotLocalSettings depotLocalSettings = DimensionalDepotLocalSettings.getInstance();
        boolean flipState = !depotLocalSettings.getCraftFromDepotState();
        depotLocalSettings.setCraftFromDepotState(flipState);
        DimensionalDepotLocalSettings.save();
        return flipState;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        this.ignoreTextInput = false;
        if (!this.isVisible() || this.minecraft.player.isSpectator()) {
            return false;
        }
        if (pKeyCode == 256 && !this.isOffsetNextToMainGUI()) {
            this.setVisible(false);
            return true;
        }
        if (this.searchBox.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            this.checkSearchStringUpdate();
            return true;
        }
        if (this.searchBox.isFocused() && this.searchBox.isVisible() && pKeyCode != 256) {
            return true;
        }
        if (this.minecraft.options.keyChat.matches(pKeyCode, pScanCode) && !this.searchBox.isFocused()) {
            this.ignoreTextInput = true;
            this.searchBox.setFocused(true);
            return true;
        }
        return false;
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        this.ignoreTextInput = false;
        return super.keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (this.ignoreTextInput) {
            return false;
        }
        if (!this.isVisible() || this.minecraft.player.isSpectator()) {
            return false;
        }
        if (this.searchBox.charTyped(pCodePoint, pModifiers)) {
            this.checkSearchStringUpdate();
            return true;
        }
        return super.charTyped(pCodePoint, pModifiers);
    }

    public boolean isMouseOver(double pMouseX, double pMouseY) {
        return false;
    }

    public boolean isMouseOverUploadSlot(double mouseX, double mouseY) {
        for (Slot slot : this.uploadSlots) {
            if (!this.isHovering(slot, mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public void setFocused(boolean pFocused) {
    }

    public boolean isFocused() {
        return false;
    }

    private void checkSearchStringUpdate() {
        String s = this.searchBox.getValue().toLowerCase(Locale.ROOT);
        if (!s.equals(this.lastSearch)) {
            this.updateCollections(false);
            this.lastSearch = s;
        }
    }

    private boolean isOffsetNextToMainGUI() {
        return this.xOffset == 86;
    }

    public void depotItemsUpdated() {
        if (this.isVisible()) {
            this.updateCollections(false);
        }
    }

    public Rect2i getDepotRect() {
        int anchoredX = this.getStartingX();
        int anchoredY = this.getStartingY();
        return new Rect2i(anchoredX, anchoredY, 147, 166);
    }

    public Rect2i getUploadRect() {
        int anchoredX = this.getStartingX();
        int anchoredY = this.getStartingY() + 166;
        return new Rect2i(anchoredX, anchoredY, 105, 25);
    }
}

