/*
 * Decompiled with CFR 0.152.
 */
package leaf.satisfactory.dimensionaldepot.common;

import leaf.satisfactory.dimensionaldepot.DimensionalDepot;
import leaf.satisfactory.dimensionaldepot.common.DimensionalDepotItemHandler;
import leaf.satisfactory.dimensionaldepot.common.network.PacketUtils;
import leaf.satisfactory.dimensionaldepot.common.network.to_client.player_data.PacketPlayerData;
import leaf.satisfactory.dimensionaldepot.common.registries.AttachmentRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class DimensionalDepotCap
implements IItemHandler {
    private final Player player;
    private final DimensionalDepotItemHandler data;
    private boolean isDirty = false;

    public DimensionalDepotCap(Player player) {
        this.player = player;
        this.data = (DimensionalDepotItemHandler)((Object)this.player.getData(AttachmentRegistry.DEPOT_HANDLER));
    }

    public int getSlots() {
        return this.data.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.data.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack itemStack = this.data.insertItem(slot, stack, simulate);
        if (!simulate && itemStack.isEmpty()) {
            this.isDirty = true;
        }
        return itemStack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack itemStack = this.data.extractItem(slot, amount, simulate);
        if (!simulate && !itemStack.isEmpty()) {
            this.isDirty = true;
        }
        return itemStack;
    }

    public int getSlotLimit(int slot) {
        return this.data.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.data.isItemValid(slot, stack);
    }

    public void Tick() {
        --this.data.timer;
        if (this.data.timer <= 0) {
            if (this.data.upload()) {
                this.isDirty = true;
            }
            this.data.timer = this.data.getMaxCountdownTimer();
        }
        if (this.isDirty) {
            this.isDirty = false;
            this.sendStateUpdate(this.player);
        }
    }

    public void sendStateUpdate(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player.setData(AttachmentRegistry.DEPOT_HANDLER, (Object)this.data);
            PacketPlayerData dataPayload = new PacketPlayerData(player.getId(), this.data.serializeNBT((HolderLookup.Provider)player.level().registryAccess()));
            PacketUtils.sendTo(dataPayload, serverPlayer);
        }
    }

    public void uploadItem(ItemStack itemStack) {
        this.data.addStackToUploadQueue(itemStack);
    }

    public void upgradeSpeed() {
        this.data.speedTier = Math.min(this.data.speedTier + 1, 9);
        DimensionalDepot.LOGGER.info(this.player.getName().getString() + " upgraded speed to tier " + this.data.speedTier);
        this.sendStateUpdate(this.player);
    }

    public void upgradeStackLimit() {
        this.data.stackLimitTier = Math.min(this.data.stackLimitTier + 1, 5);
        DimensionalDepot.LOGGER.info(this.player.getName().getString() + " upgraded stack limit to tier " + this.data.stackLimitTier);
        this.sendStateUpdate(this.player);
    }

    public void resetUpgrades() {
        this.data.stackLimitTier = 1;
        this.data.speedTier = 0;
        DimensionalDepot.LOGGER.info(this.player.getName().getString() + " reset upgrades");
        this.sendStateUpdate(this.player);
    }

    public ItemStackHandler getUploadQueue() {
        return this.data.uploadSlots;
    }

    public int getSpeedTier() {
        return this.data.speedTier;
    }
}

