/*
 * Decompiled with CFR 0.152.
 */
package leaf.satisfactory.dimensionaldepot.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import leaf.satisfactory.dimensionaldepot.DimensionalDepot;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.DataComponentUtil;
import net.neoforged.neoforge.items.ItemStackHandler;

public class DimensionalDepotItemHandler
extends ItemStackHandler {
    protected final ItemStackHandler uploadSlots;
    public int timer = 240;
    public int speedTier = 0;
    public int stackLimitTier = 1;
    public static final Codec<ItemStack> LARGER_STACK_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(stackInstance -> stackInstance.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.intRange((int)1, (int)384).fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)stackInstance, ItemStack::new)));

    public DimensionalDepotItemHandler() {
        this.stacks = NonNullList.withSize((int)81, (Object)ItemStack.EMPTY);
        this.uploadSlots = new ItemStackHandler(5);
    }

    public int getSlots() {
        return this.stacks.size();
    }

    public int getSlotLimit(int slot) {
        return 999;
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        return stack.getMaxStackSize() * this.stackLimitTier;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return super.isItemValid(slot, stack);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = this.serializeThis(provider);
        tag.put("upload", (Tag)this.uploadSlots.serializeNBT(provider));
        tag.putInt("timer", this.timer);
        tag.putInt("speedTier", this.speedTier);
        tag.putInt("stackLimitTier", this.stackLimitTier);
        return tag;
    }

    public CompoundTag serializeThis(HolderLookup.Provider provider) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            Tag saveStack = DimensionalDepotItemHandler.saveWithLargeStackCodec((ItemStack)this.stacks.get(i), provider, (Tag)itemTag);
            nbtTagList.add((Object)saveStack);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Items", (Tag)nbtTagList);
        nbt.putInt("Size", this.stacks.size());
        return nbt;
    }

    public static Tag saveWithLargeStackCodec(ItemStack itemStack, HolderLookup.Provider pLevelRegistryAccess, Tag pOutputTag) {
        if (itemStack.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ItemStack");
        }
        return DataComponentUtil.wrapEncodingExceptions((DataComponentHolder)itemStack, LARGER_STACK_CODEC, (HolderLookup.Provider)pLevelRegistryAccess, (Tag)pOutputTag);
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.deserializeThis(provider, tag);
        if (tag.contains("upload")) {
            this.uploadSlots.deserializeNBT(provider, tag.getCompound("upload"));
        }
        if (tag.contains("timer")) {
            this.timer = tag.getInt("timer");
        }
        if (tag.contains("speedTier")) {
            this.speedTier = tag.getInt("speedTier");
        }
        if (tag.contains("stackLimitTier")) {
            this.stackLimitTier = tag.getInt("stackLimitTier");
        }
    }

    public void deserializeThis(HolderLookup.Provider provider, CompoundTag nbt) {
        this.setSize(nbt.contains("Size", 3) ? nbt.getInt("Size") : this.stacks.size());
        ListTag tagList = nbt.getList("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.getCompound(i);
            int slot = itemTags.getInt("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            DimensionalDepotItemHandler.parse(provider, (Tag)itemTags).ifPresent(stack -> this.stacks.set(slot, stack));
        }
        this.onLoad();
    }

    public static Optional<ItemStack> parse(HolderLookup.Provider pLookupProvider, Tag pTag) {
        return LARGER_STACK_CODEC.parse((DynamicOps)pLookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)pTag).resultOrPartial(error -> DimensionalDepot.LOGGER.error("Tried to load invalid item: '{}'", error));
    }

    public int getMaxCountdownTimer() {
        if (this.speedTier <= 5) {
            return Math.max(5, 80 >> Math.max(1, this.speedTier) - 1);
        }
        return Math.max(1, 5 - (this.speedTier - 5));
    }

    public boolean upload() {
        for (int uploadIndex = 0; uploadIndex < this.uploadSlots.getSlots(); ++uploadIndex) {
            Object cloudStack;
            int cloudIndex;
            ItemStack stackToUpload;
            if (this.uploadSlots.getStackInSlot(uploadIndex).isEmpty() || (stackToUpload = this.uploadSlots.extractItem(uploadIndex, 1, true)).isEmpty()) continue;
            ArrayList<Integer> matchingIndices = new ArrayList<Integer>();
            for (cloudIndex = 0; cloudIndex < this.getSlots(); ++cloudIndex) {
                cloudStack = (ItemStack)this.stacks.get(cloudIndex);
                if (cloudStack.isEmpty() || !this.stacksMatch((ItemStack)cloudStack, stackToUpload)) continue;
                matchingIndices.add(cloudIndex);
            }
            if (!matchingIndices.isEmpty()) {
                boolean inserted = false;
                cloudStack = matchingIndices.iterator();
                while (cloudStack.hasNext()) {
                    int cloudIndex2 = (Integer)cloudStack.next();
                    ItemStack remainderFromUpload = this.insertItem(cloudIndex2, stackToUpload, true);
                    if (!remainderFromUpload.isEmpty()) continue;
                    this.insertItem(cloudIndex2, this.uploadSlots.extractItem(uploadIndex, 1, false), false);
                    inserted = true;
                    break;
                }
                if (!inserted) continue;
                this.sortStacks();
                return true;
            }
            for (cloudIndex = 0; cloudIndex < this.getSlots(); ++cloudIndex) {
                ItemStack remainderFromUpload;
                cloudStack = (ItemStack)this.stacks.get(cloudIndex);
                if (!cloudStack.isEmpty() || !(remainderFromUpload = this.insertItem(cloudIndex, stackToUpload, true)).isEmpty()) continue;
                this.insertItem(cloudIndex, this.uploadSlots.extractItem(uploadIndex, 1, false), false);
                this.sortStacks();
                return true;
            }
        }
        return false;
    }

    private void sortStacks() {
        this.stacks.sort((p1, p2) -> {
            if (p1.isEmpty()) {
                if (p2.isEmpty()) {
                    return 0;
                }
                return 1;
            }
            if (p2.isEmpty()) {
                return -1;
            }
            return Integer.compare(p1.getCount(), p2.getCount());
        });
    }

    private boolean stacksMatch(ItemStack a, ItemStack b) {
        if (a == null || b == null || a.isEmpty() || b.isEmpty()) {
            return false;
        }
        return a.getItem() == b.getItem();
    }

    public void addStackToUploadQueue(ItemStack itemStack) {
        for (int i = 0; i < this.uploadSlots.getSlots(); ++i) {
            if (!this.uploadSlots.insertItem(i, itemStack, true).isEmpty()) continue;
            this.uploadSlots.insertItem(i, itemStack, false);
            return;
        }
    }

    public Map.Entry<Integer, Integer> getSlotForItem(Item item) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stackInSlot = this.getStackInSlot(i);
            if (stackInSlot.isEmpty() || stackInSlot.getItem() != item) continue;
            return Map.entry(i, stackInSlot.getCount());
        }
        return Map.entry(-1, -1);
    }
}

