/*
 * Decompiled with CFR 0.152.
 */
package leaf.satisfactory.dimensionaldepot.common;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import leaf.satisfactory.dimensionaldepot.DimensionalDepot;
import net.minecraft.client.Minecraft;

public class DimensionalDepotLocalSettings {
    private static final String SETTINGS_FILE = "DimensionalDepotSaveState.json";
    private static final String DEFAULT_SETTINGS_FILE = "DimensionalDepotSaveState.default.json";
    private static final Gson gson = new Gson();
    private static DimensionalDepotLocalSettings instance;
    private boolean craftFromDepotEnabled = false;
    private final Set<String> hintsSeen = new HashSet<String>();

    public static void save() {
        try (FileWriter writer = new FileWriter(new File(Minecraft.getInstance().gameDirectory, SETTINGS_FILE));){
            gson.toJson((Object)instance, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasSeenHint(String hint) {
        return this.hintsSeen.contains(hint);
    }

    public void markHintAsSeen(String hint) {
        this.hintsSeen.add(hint);
    }

    public static DimensionalDepotLocalSettings getInstance() {
        if (instance == null) {
            File saveStateFile = new File(Minecraft.getInstance().gameDirectory, SETTINGS_FILE);
            File defaultSaveStateFile = new File(Minecraft.getInstance().gameDirectory, DEFAULT_SETTINGS_FILE);
            if (!saveStateFile.exists() && defaultSaveStateFile.exists()) {
                try {
                    Files.copy(defaultSaveStateFile.toPath(), saveStateFile.toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    DimensionalDepot.LOGGER.error("Failed to load DimensionalDepot default save state, will ignore defaults", (Throwable)e);
                }
            }
            if (saveStateFile.exists()) {
                try (FileReader reader = new FileReader(saveStateFile);){
                    instance = (DimensionalDepotLocalSettings)gson.fromJson((Reader)reader, DimensionalDepotLocalSettings.class);
                }
                catch (Throwable e) {
                    DimensionalDepot.LOGGER.error("Failed to load DimensionalDepot save state, resetting to default", e);
                }
            }
        }
        if (instance == null) {
            instance = new DimensionalDepotLocalSettings();
        }
        return instance;
    }

    public boolean getCraftFromDepotState() {
        return this.craftFromDepotEnabled;
    }

    public void setCraftFromDepotState(boolean state) {
        this.craftFromDepotEnabled = state;
    }
}

