/*
 * Decompiled with CFR 0.152.
 */
package leaf.satisfactory.dimensionaldepot.common.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SomersloopBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final MapCodec<SomersloopBlock> CODEC = SomersloopBlock.simpleCodec(SomersloopBlock::new);
    protected static final VoxelShape UP_NS_AABB = Shapes.box((double)0.125, (double)0.0, (double)0.3125, (double)0.875, (double)1.0, (double)0.6875);
    protected static final VoxelShape UP_EW_AABB = Shapes.box((double)0.3125, (double)0.0, (double)0.125, (double)0.6875, (double)1.0, (double)0.875);
    protected static final VoxelShape WALL_NS_AABB = Shapes.box((double)0.0, (double)0.3125, (double)0.125, (double)1.0, (double)0.6875, (double)0.875);
    protected static final VoxelShape WALL_EW_AABB = Shapes.box((double)0.125, (double)0.3125, (double)0.0, (double)0.875, (double)0.6875, (double)1.0);

    public SomersloopBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FACE, (Comparable)AttachFace.WALL));
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return false;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return switch ((AttachFace)blockState.getValue((Property)FACE)) {
            default -> throw new MatchException(null, null);
            case AttachFace.CEILING, AttachFace.FLOOR -> {
                switch ((Direction)blockState.getValue((Property)FACING)) {
                    case EAST: 
                    case WEST: {
                        yield UP_EW_AABB;
                    }
                }
                yield UP_NS_AABB;
            }
            case AttachFace.WALL -> {
                switch ((Direction)blockState.getValue((Property)FACING)) {
                    case EAST: 
                    case WEST: {
                        yield WALL_NS_AABB;
                    }
                }
                yield WALL_EW_AABB;
            }
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACE, FACING});
    }
}

