/*
 * Decompiled with CFR 0.152.
 */
package leaf.satisfactory.dimensionaldepot.common.events;

import leaf.satisfactory.dimensionaldepot.common.DimensionalDepotCap;
import leaf.satisfactory.dimensionaldepot.common.registries.BlocksRegistry;
import leaf.satisfactory.dimensionaldepot.common.registries.ItemsRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="dimensionaldepot", bus=EventBusSubscriber.Bus.GAME)
public class EventsGame {
    public static final EntityCapability<DimensionalDepotCap, @Nullable Void> DEPOT = EntityCapability.createVoid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"satisfactory", (String)"dimensional_depot"), DimensionalDepotCap.class);

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Post event) {
        Player player;
        DimensionalDepotCap capability;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (capability = (DimensionalDepotCap)(player = (Player)entity).getCapability(DEPOT)) != null) {
            capability.Tick();
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            DimensionalDepotCap capability = (DimensionalDepotCap)event.getEntity().getCapability(DEPOT);
            if (capability != null) {
                capability.sendStateUpdate((Player)player);
            }
        }
    }

    @SubscribeEvent
    public static void onUseItemOnBlockEvent(UseItemOnBlockEvent event) {
    }

    @SubscribeEvent
    public static void onFinishUsingItem(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            DimensionalDepotCap capability;
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (event.getItem().is(BlocksRegistry.MERCER_SPHERE_ITEM)) {
                capability = (DimensionalDepotCap)player.getCapability(DEPOT);
                if (capability != null) {
                    capability.upgradeSpeed();
                }
            } else if (event.getItem().is(BlocksRegistry.SOMERSLOOP_ITEM)) {
                capability = (DimensionalDepotCap)player.getCapability(DEPOT);
                if (capability != null) {
                    capability.upgradeStackLimit();
                }
            } else if (event.getItem().is(ItemsRegistry.RESET) && (capability = (DimensionalDepotCap)player.getCapability(DEPOT)) != null) {
                capability.resetUpgrades();
            }
        }
    }
}

