/*
 * Decompiled with CFR 0.152.
 */
package leaf.satisfactory.dimensionaldepot.common.network;

import leaf.satisfactory.dimensionaldepot.common.network.ICustomPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public abstract class BasePacketHandler {
    protected BasePacketHandler(IEventBus modEventBus, String version) {
        modEventBus.addListener(RegisterPayloadHandlersEvent.class, event -> {
            PayloadRegistrar registrar = event.registrar(version.toString());
            this.registerClientToServer(new PacketRegistrar(registrar, true));
            this.registerServerToClient(new PacketRegistrar(registrar, false));
        });
    }

    protected abstract void registerClientToServer(PacketRegistrar var1);

    protected abstract void registerServerToClient(PacketRegistrar var1);

    protected record PacketRegistrar(PayloadRegistrar registrar, boolean toServer) {
        public <MSG extends ICustomPacket> void play(CustomPacketPayload.Type<MSG> type, StreamCodec<? super RegistryFriendlyByteBuf, MSG> reader) {
            if (this.toServer) {
                this.registrar.playToServer(type, reader, ICustomPacket::handle);
            } else {
                this.registrar.playToClient(type, reader, ICustomPacket::handle);
            }
        }

        public SimplePacketPayLoad playInstanced(ResourceLocation id, IPayloadHandler<CustomPacketPayload> handler) {
            SimplePacketPayLoad payload = new SimplePacketPayLoad(id);
            if (this.toServer) {
                this.registrar.playToServer(payload.type(), StreamCodec.unit((Object)payload), handler);
            } else {
                this.registrar.playToClient(payload.type(), StreamCodec.unit((Object)payload), handler);
            }
            return payload;
        }
    }

    protected record SimplePacketPayLoad(CustomPacketPayload.Type<CustomPacketPayload> type) implements CustomPacketPayload
    {
        private SimplePacketPayLoad(ResourceLocation id) {
            this((CustomPacketPayload.Type<CustomPacketPayload>)new CustomPacketPayload.Type(id));
        }
    }
}

