/*
 * Decompiled with CFR 0.152.
 */
package leaf.satisfactory.dimensionaldepot.common.network.to_client.player_data;

import io.netty.buffer.ByteBuf;
import leaf.satisfactory.dimensionaldepot.DimensionalDepot;
import leaf.satisfactory.dimensionaldepot.common.DimensionalDepotItemHandler;
import leaf.satisfactory.dimensionaldepot.common.network.ICustomPacket;
import leaf.satisfactory.dimensionaldepot.common.registries.AttachmentRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketPlayerData(int entityID, CompoundTag compoundTag) implements ICustomPacket
{
    public static StreamCodec<ByteBuf, PacketPlayerData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, PacketPlayerData::entityID, (StreamCodec)ByteBufCodecs.TRUSTED_COMPOUND_TAG, PacketPlayerData::compoundTag, PacketPlayerData::new);
    public static final CustomPacketPayload.Type<PacketPlayerData> TYPE = new CustomPacketPayload.Type(DimensionalDepot.rl("player_data"));

    @NotNull
    public CustomPacketPayload.Type<PacketPlayerData> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        Entity result;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && (result = level.getEntity(this.entityID)) instanceof Player) {
            Player player = (Player)result;
            DimensionalDepotItemHandler data = (DimensionalDepotItemHandler)((Object)result.getData(AttachmentRegistry.DEPOT_HANDLER));
            data.deserializeNBT((HolderLookup.Provider)level.registryAccess(), this.compoundTag);
            player.getInventory().setChanged();
        }
    }
}

