/*
 * Decompiled with CFR 0.152.
 */
package leaf.satisfactory.dimensionaldepot.common.network.to_server.take_from_cloud;

import io.netty.buffer.ByteBuf;
import leaf.satisfactory.dimensionaldepot.DimensionalDepot;
import leaf.satisfactory.dimensionaldepot.common.DimensionalDepotCap;
import leaf.satisfactory.dimensionaldepot.common.events.EventsGame;
import leaf.satisfactory.dimensionaldepot.common.network.ICustomPacket;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ClickUploadSlotPacket(boolean shift, int mouse, int slotIndex) implements ICustomPacket
{
    public static StreamCodec<ByteBuf, ClickUploadSlotPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ClickUploadSlotPacket::shift, (StreamCodec)ByteBufCodecs.VAR_INT, ClickUploadSlotPacket::mouse, (StreamCodec)ByteBufCodecs.VAR_INT, ClickUploadSlotPacket::slotIndex, ClickUploadSlotPacket::new);
    public static final CustomPacketPayload.Type<ClickUploadSlotPacket> TYPE = new CustomPacketPayload.Type(DimensionalDepot.rl("click_upload_slot"));

    @NotNull
    public CustomPacketPayload.Type<ClickUploadSlotPacket> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        ServerPlayer player;
        DimensionalDepotCap depotCap;
        Player player2 = context.player();
        if (player2 instanceof ServerPlayer && (depotCap = (DimensionalDepotCap)(player = (ServerPlayer)player2).getCapability(EventsGame.DEPOT)) != null) {
            ClickAction clickaction;
            ItemStackHandler uploadQueue = depotCap.getUploadQueue();
            ItemStack stackInSlot = uploadQueue.getStackInSlot(this.slotIndex);
            ItemStack carried = this.getCarried(player);
            ClickAction clickAction = clickaction = this.mouse == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
            if (stackInSlot.isEmpty()) {
                if (!carried.isEmpty()) {
                    int amountToMove = clickaction == ClickAction.PRIMARY ? carried.getCount() : 1;
                    this.setCarried(player, this.safeInsert(uploadQueue, this.slotIndex, carried, amountToMove));
                }
            } else if (carried.isEmpty()) {
                int amount = clickaction == ClickAction.PRIMARY ? stackInSlot.getCount() : (stackInSlot.getCount() + 1) / 2;
                ItemStack stack = depotCap.getUploadQueue().extractItem(this.slotIndex, amount, false);
                this.setCarried(player, stack);
            } else if (ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)carried)) {
                int amount = clickaction == ClickAction.PRIMARY ? carried.getCount() : 1;
                this.setCarried(player, this.safeInsert(uploadQueue, this.slotIndex, carried, amount));
            } else if (carried.getCount() <= carried.getMaxStackSize()) {
                this.setCarried(player, stackInSlot);
                uploadQueue.setStackInSlot(this.slotIndex, carried);
            }
            player.getInventory().setChanged();
            depotCap.sendStateUpdate((Player)player);
        }
    }

    public ItemStack safeInsert(ItemStackHandler uploadQueue, int slotIndex, ItemStack carried, int pIncrement) {
        if (!carried.isEmpty()) {
            ItemStack stackInSlot = uploadQueue.getStackInSlot(slotIndex);
            int i = Math.min(Math.min(pIncrement, carried.getCount()), carried.getMaxStackSize() - stackInSlot.getCount());
            if (stackInSlot.isEmpty()) {
                uploadQueue.setStackInSlot(slotIndex, carried.split(i));
            } else if (ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)carried)) {
                carried.shrink(i);
                stackInSlot.grow(i);
                uploadQueue.setStackInSlot(slotIndex, stackInSlot);
            }
        }
        return carried;
    }

    private ItemStack getCarried(ServerPlayer player) {
        return player.containerMenu.getCarried();
    }

    private void setCarried(ServerPlayer player, ItemStack stack) {
        player.containerMenu.setCarried(stack);
    }
}

