/*
 * Decompiled with CFR 0.152.
 */
package leaf.satisfactory.dimensionaldepot.common.network.to_server.take_from_cloud;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import leaf.satisfactory.dimensionaldepot.DimensionalDepot;
import leaf.satisfactory.dimensionaldepot.common.DimensionalDepotCap;
import leaf.satisfactory.dimensionaldepot.common.DimensionalDepotItemHandler;
import leaf.satisfactory.dimensionaldepot.common.events.EventsGame;
import leaf.satisfactory.dimensionaldepot.common.network.ICustomPacket;
import leaf.satisfactory.dimensionaldepot.common.registries.AttachmentRegistry;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record DownloadItemPacket(boolean shift, int mouse, ItemStack itemstack) implements ICustomPacket
{
    public static StreamCodec<ByteBuf, DownloadItemPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, DownloadItemPacket::shift, (StreamCodec)ByteBufCodecs.VAR_INT, DownloadItemPacket::mouse, (StreamCodec)ByteBufCodecs.fromCodec(DimensionalDepotItemHandler.LARGER_STACK_CODEC), DownloadItemPacket::itemstack, DownloadItemPacket::new);
    public static final CustomPacketPayload.Type<DownloadItemPacket> TYPE = new CustomPacketPayload.Type(DimensionalDepot.rl("download_item"));

    @NotNull
    public CustomPacketPayload.Type<DownloadItemPacket> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            int amount;
            ServerPlayer player2 = (ServerPlayer)player;
            DimensionalDepotItemHandler data = (DimensionalDepotItemHandler)((Object)player2.getData(AttachmentRegistry.DEPOT_HANDLER));
            if (this.itemstack.isEmpty()) {
                DimensionalDepot.LOGGER.error("Failed to parse item stack from depot download packet");
                return;
            }
            Item item = this.itemstack.getItem();
            Map.Entry<Integer, Integer> slotForItem = data.getSlotForItem(item);
            if (slotForItem.getKey() == -1) {
                DimensionalDepot.LOGGER.error("Failed to find item in depot for download");
                return;
            }
            int slotIndex = slotForItem.getKey();
            int itemCount = slotForItem.getValue();
            int countToExtract = Math.min(this.itemstack.getMaxStackSize(), itemCount);
            int n = amount = this.mouse == 0 ? countToExtract : 1;
            if (data.extractItem(slotIndex, amount, true).isEmpty()) {
                DimensionalDepot.LOGGER.error("Failed to download item from depot");
                return;
            }
            ItemStack extracted = data.extractItem(slotIndex, amount, false);
            if (this.shift) {
                if (!player2.getInventory().add(extracted)) {
                    player2.drop(extracted, false);
                }
            } else if (player2.containerMenu.getCarried().isEmpty()) {
                player2.containerMenu.setCarried(extracted);
            } else if (ItemStack.isSameItemSameComponents((ItemStack)player2.containerMenu.getCarried(), (ItemStack)extracted)) {
                ItemStack mouseStack = player2.containerMenu.getCarried();
                int spaceInMouse = mouseStack.getMaxStackSize() - mouseStack.getCount();
                if (spaceInMouse >= extracted.getCount()) {
                    mouseStack.grow(extracted.getCount());
                } else {
                    mouseStack.grow(spaceInMouse);
                    extracted.shrink(spaceInMouse);
                    if (!player2.getInventory().add(extracted)) {
                        player2.drop(extracted, false);
                    }
                }
            } else if (!player2.getInventory().add(extracted)) {
                player2.drop(extracted, false);
            }
            player2.getInventory().setChanged();
            DimensionalDepotCap capability = (DimensionalDepotCap)player2.getCapability(EventsGame.DEPOT);
            if (capability != null) {
                capability.sendStateUpdate((Player)player2);
            }
        }
    }
}

