/*
 * Decompiled with CFR 0.152.
 */
package com.Influence.smoothboot.mixin;

import com.Influence.smoothboot.SmoothBoot;
import com.Influence.smoothboot.util.LoggingForkJoinWorkerThread;
import com.google.common.base.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Util.class})
public abstract class UtilMixin {
    @Shadow
    @Final
    @Mutable
    private static ExecutorService BACKGROUND_EXECUTOR;
    @Shadow
    @Final
    @Mutable
    private static ExecutorService IO_POOL;
    @Shadow
    @Final
    private static AtomicInteger WORKER_COUNT;

    @Shadow
    private static native void onThreadException(Thread var0, Throwable var1);

    @Inject(method={"backgroundExecutor"}, at={@At(value="HEAD")})
    private static void onGetMainWorkerExecutor(CallbackInfoReturnable<Executor> ci) {
        if (!SmoothBoot.initMainWorker) {
            BACKGROUND_EXECUTOR = UtilMixin.replaceWorker("Main");
            SmoothBoot.LOGGER.debug("Replaced Main Executor");
            SmoothBoot.initMainWorker = true;
        }
    }

    @Inject(method={"ioPool"}, at={@At(value="HEAD")})
    private static void onGetIoWorkerExecutor(CallbackInfoReturnable<Executor> ci) {
        if (!SmoothBoot.initIOWorker) {
            IO_POOL = UtilMixin.replaceIoWorker();
            SmoothBoot.LOGGER.debug("Replaced IO Executor");
            SmoothBoot.initIOWorker = true;
        }
    }

    private static ExecutorService replaceWorker(String name) {
        if (!SmoothBoot.initConfig) {
            SmoothBoot.regConfig();
            SmoothBoot.initConfig = true;
        }
        return new ForkJoinPool(Mth.clamp((int)UtilMixin.select(name, SmoothBoot.config.threadCount.bootstrap, SmoothBoot.config.threadCount.main), (int)1, (int)Short.MAX_VALUE), forkJoinPool -> {
            String workerName = "Worker-" + name + "-" + WORKER_COUNT.getAndIncrement();
            SmoothBoot.LOGGER.debug("Initialized " + workerName);
            LoggingForkJoinWorkerThread forkJoinWorkerThread = new LoggingForkJoinWorkerThread(forkJoinPool, SmoothBoot.LOGGER);
            forkJoinWorkerThread.setPriority(UtilMixin.select(name, SmoothBoot.config.threadPriority.bootstrap, SmoothBoot.config.threadPriority.main));
            forkJoinWorkerThread.setName(workerName);
            return forkJoinWorkerThread;
        }, UtilMixin::onThreadException, true);
    }

    private static ExecutorService replaceIoWorker() {
        return Executors.newCachedThreadPool(p_240978_0_ -> {
            String workerName = "IO-Worker-" + WORKER_COUNT.getAndIncrement();
            SmoothBoot.LOGGER.debug("Initialized " + workerName);
            Thread thread = new Thread(p_240978_0_);
            thread.setName(workerName);
            thread.setPriority(SmoothBoot.config.threadPriority.io);
            thread.setUncaughtExceptionHandler(UtilMixin::onThreadException);
            return thread;
        });
    }

    private static <T> T select(String name, T bootstrap, T main) {
        return Objects.equal((Object)name, (Object)"Bootstrap") ? bootstrap : main;
    }
}

