/*
 * Decompiled with CFR 0.152.
 */
package com.Influence.smoothboot.config;

import com.Influence.smoothboot.SmoothBoot;
import com.Influence.smoothboot.config.SmoothBootConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static SmoothBootConfig readConfig() throws IOException {
        SmoothBootConfig config;
        String configPath = System.getProperty("user.dir") + "/config/smoothboot.json";
        SmoothBoot.LOGGER.debug("Config path: " + configPath);
        try (FileReader reader = new FileReader(configPath);){
            config = (SmoothBootConfig)GSON.fromJson((Reader)reader, SmoothBootConfig.class);
            if (config == null) {
                throw new NullPointerException();
            }
            config.validate();
            try (FileWriter writer = new FileWriter(configPath);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
            SmoothBoot.LOGGER.debug("Config: " + String.valueOf(config));
        }
        catch (JsonParseException | IOException | NullPointerException e) {
            config = new SmoothBootConfig();
            try (FileWriter writer = new FileWriter(configPath);){
                GSON.toJson((Object)config, (Appendable)writer);
                SmoothBoot.LOGGER.debug("New config file created");
            }
        }
        return config;
    }
}

