/*
 * Decompiled with CFR 0.152.
 */
package net.frostbyte.mobility.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.DoubleSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class MaximumMobilityConfig {
    public static final Path configDir = FabricLoader.getInstance().getConfigDir().resolve("frostbyte");
    public static final Path configFile = FabricLoader.getInstance().getConfigDir().resolve("frostbyte/maximum-mobility.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static double stepUp = 0.6;
    public static double boatStepUp = 0.0;
    public static int coyoteTime = 0;
    public static boolean elytraCancel = false;
    public static boolean reachAround = false;

    public static class_437 createScreen(class_437 parent) {
        MaximumMobilityConfig.read();
        return YetAnotherConfigLib.createBuilder().title(class_2561.method_30163((String)"Frostbyte's Maximum Mobility Config Menu")).category(ConfigCategory.createBuilder().name(class_2561.method_30163((String)"Frostbyte's Maximum Mobility")).tooltip(new class_2561[]{class_2561.method_30163((String)"Configuration menu for Frostbyte's Maximum Mobility")}).option(Option.createBuilder().name(class_2561.method_30163((String)"Player Step Height")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"The number of blocks that the player can walk up without jumping")})).binding((Object)0.6, () -> stepUp, newVal -> {
            stepUp = newVal;
        }).controller(option -> MaximumMobilityConfig.doubleSliderController((Option<Double>)option, 0.0, 10.0, 0.1)).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Boat Step Height")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"The number of blocks that a boat can move up")})).binding((Object)0.0, () -> boatStepUp, newVal -> {
            boatStepUp = newVal;
        }).controller(option -> MaximumMobilityConfig.doubleSliderController((Option<Double>)option, 0.0, 10.0, 0.1)).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Coyote Time")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"The number of ticks after falling off of a block that the player can still jump")})).binding((Object)0, () -> coyoteTime, newVal -> {
            coyoteTime = newVal;
        }).controller(option -> MaximumMobilityConfig.integerSliderController((Option<Integer>)option, 0, 100, 1)).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Elytra Cancel")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"The ability to stop using the elytra if the jump key is pressed, like is possible in Bedrock Edition")})).binding((Object)false, () -> elytraCancel, newVal -> {
            elytraCancel = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Reach Around Block Placement")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"The ability to place a block in front of the player, like is possible in Bedrock Edition")})).binding((Object)false, () -> reachAround, newVal -> {
            reachAround = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).build()).save(MaximumMobilityConfig::write).build().generateScreen(parent);
    }

    private static DoubleSliderControllerBuilder doubleSliderController(Option<Double> option, double min, double max, double step) {
        return (DoubleSliderControllerBuilder)((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create(option).range((Number)min, (Number)max)).step((Number)step);
    }

    private static IntegerSliderControllerBuilder integerSliderController(Option<Integer> option, int min, int max, int step) {
        return (IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create(option).range((Number)min, (Number)max)).step((Number)step);
    }

    public static void write() {
        try {
            if (Files.notExists(configDir, new LinkOption[0])) {
                Files.createDirectory(configDir, new FileAttribute[0]);
            }
            Files.deleteIfExists(configFile);
            JsonObject json = new JsonObject();
            json.addProperty("stepUp", (Number)stepUp);
            json.addProperty("boatStepUp", (Number)boatStepUp);
            json.addProperty("coyoteTime", (Number)coyoteTime);
            json.addProperty("elytraCancel", Boolean.valueOf(elytraCancel));
            json.addProperty("reachAround", Boolean.valueOf(reachAround));
            Files.writeString(configFile, (CharSequence)gson.toJson((JsonElement)json), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void read() {
        try {
            if (Files.notExists(configFile, new LinkOption[0])) {
                MaximumMobilityConfig.write();
                return;
            }
            JsonObject json = (JsonObject)gson.fromJson(Files.readString(configFile), JsonObject.class);
            if (json.has("stepUp")) {
                stepUp = json.getAsJsonPrimitive("stepUp").getAsFloat();
            }
            if (json.has("boatStepUp")) {
                boatStepUp = json.getAsJsonPrimitive("boatStepUp").getAsFloat();
            }
            if (json.has("coyoteTime")) {
                coyoteTime = json.getAsJsonPrimitive("coyoteTime").getAsInt();
            }
            if (json.has("elytraCancel")) {
                elytraCancel = json.getAsJsonPrimitive("elytraCancel").getAsBoolean();
            }
            if (json.has("reachAround")) {
                reachAround = json.getAsJsonPrimitive("reachAround").getAsBoolean();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

