/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.exclusiveitem.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ExclusiveItemConfig {
    public boolean guiEnabled = true;
    public int requiredXpLevels = 0;
    public List<RequiredItem> requiredItems = List.of(new RequiredItem(this, "minecraft:nether_star", 1));
    public static final ExclusiveItemConfig INSTANCE = new ExclusiveItemConfig();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/exclusiveitem_config.json");

    public void load() {
        try {
            if (!CONFIG_FILE.exists()) {
                this.save();
                return;
            }
            FileReader reader = new FileReader(CONFIG_FILE);
            ExclusiveItemConfig loaded = (ExclusiveItemConfig)GSON.fromJson((Reader)reader, ExclusiveItemConfig.class);
            if (loaded != null) {
                this.guiEnabled = loaded.guiEnabled;
                this.requiredXpLevels = loaded.requiredXpLevels;
                this.requiredItems = loaded.requiredItems != null ? loaded.requiredItems : this.requiredItems;
            }
        }
        catch (Exception e) {
            System.err.println("[ExclusiveItem] Failed to load config: " + e.getMessage());
        }
    }

    public void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(CONFIG_FILE);
            GSON.toJson((Object)this, (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            System.err.println("[ExclusiveItem] Failed to save config: " + e.getMessage());
        }
    }

    public List<class_1799> getRequiredItemStacks() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (RequiredItem entry : this.requiredItems) {
            class_2960 id = class_2960.method_12829((String)entry.id);
            if (id == null || !class_7923.field_41178.method_10250(id)) continue;
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            stacks.add(new class_1799((class_1935)item, Math.max(1, entry.count)));
        }
        return stacks;
    }

    public class RequiredItem {
        public String id;
        public int count;

        public RequiredItem(ExclusiveItemConfig this$0, String id, int count) {
            this.id = id;
            this.count = count;
        }

        public RequiredItem(ExclusiveItemConfig this$0) {
        }
    }
}

