/*
 * Decompiled with CFR 0.152.
 */
package de.fanta.cubeside;

import com.mojang.brigadier.CommandDispatcher;
import de.fanta.cubeside.CubesideClientFabric;
import de.fanta.cubeside.KeyBinds;
import de.fanta.cubeside.MiningAssistent;
import de.fanta.cubeside.config.Configs;
import de.fanta.cubeside.data.ChatDatabase;
import de.fanta.cubeside.util.ChatHudMethods;
import de.fanta.cubeside.util.ChatUtils;
import de.fanta.cubeside.util.SoundThread;
import de.iani.cubesideutils.fabric.permission.PermissionHandler;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1132;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1821;
import net.minecraft.class_2338;
import net.minecraft.class_2478;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_4341;
import net.minecraft.class_4877;
import net.minecraft.class_4879;
import net.minecraft.class_5218;
import net.minecraft.class_5455;
import net.minecraft.class_5498;
import net.minecraft.class_634;
import net.minecraft.class_642;
import org.apache.logging.log4j.Level;

public class Events {
    private boolean flyingLastTick = false;
    private class_5498 lastmode = class_5498.field_26664;
    private class_3414 sound;
    private SoundThread soundThread;
    private boolean connect;
    private LocalDate lastTickDate;

    public void init() {
        ClientPlayConnectionEvents.INIT.register((handler, client) -> {
            if (Configs.Chat.SaveMessagesToDatabase.getBooleanValue() && !CubesideClientFabric.databaseinuse) {
                if (!this.connect) {
                    int portSepLoc;
                    String worldName = client.method_1496() ? this.getMapName(client) : this.getServerName(handler);
                    if (worldName == null) {
                        CubesideClientFabric.LOGGER.log(Level.WARN, "WorldName is Null :(");
                        return;
                    }
                    if (worldName.endsWith(":25565") && (portSepLoc = worldName.lastIndexOf(58)) != -1) {
                        worldName = worldName.substring(0, portSepLoc);
                    }
                    String finalWorldName = Events.scrubNameFile(worldName);
                    this.connect = true;
                    CubesideClientFabric.setLoadingMessages(true);
                    try {
                        CubesideClientFabric.setChatDatabase(new ChatDatabase(finalWorldName, (class_5455)handler.method_29091()));
                        List<class_2561> messages = CubesideClientFabric.getChatDatabase().loadMessages(Configs.Chat.ChatMessageLimit.getIntegerValue());
                        List<String> commands = CubesideClientFabric.getChatDatabase().loadCommands();
                        client.field_1705.method_1743().method_1808(true);
                        if (messages != null) {
                            messages.forEach(((ChatHudMethods)client.field_1705.method_1743())::cubesideMod$addStoredChatMessage);
                        }
                        if (commands != null) {
                            commands.forEach(((ChatHudMethods)client.field_1705.method_1743())::cubesideMod$addStoredCommand);
                        }
                    }
                    finally {
                        CubesideClientFabric.setLoadingMessages(false);
                        CubesideClientFabric.messageQueue.forEach(text -> client.field_1705.method_1743().method_1812(text));
                        CubesideClientFabric.messageQueue.clear();
                    }
                }
                if (Configs.HitBox.KeepEntityHitBox.getBooleanValue()) {
                    // empty if block
                }
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            ChatDatabase chatDatabase = CubesideClientFabric.getChatDatabase();
            if (chatDatabase != null) {
                chatDatabase.close();
                CubesideClientFabric.setChatDatabase(null);
            }
            if (Configs.Chat.SaveMessagesToDatabase.getBooleanValue()) {
                this.connect = false;
            }
            CubesideClientFabric.setChatInfo(null);
        });
        ClientTickEvents.END_CLIENT_TICK.register(mc -> {
            if (mc.field_1724 != null) {
                if (Configs.Generic.ThirdPersonElytra.getBooleanValue()) {
                    if (mc.field_1724.method_6128()) {
                        if (!this.flyingLastTick) {
                            this.flyingLastTick = true;
                            this.lastmode = mc.field_1690.method_31044();
                            mc.field_1690.method_31043(class_5498.field_26665);
                        }
                    } else if (this.flyingLastTick) {
                        this.flyingLastTick = false;
                        mc.field_1690.method_31043(this.lastmode);
                    }
                }
                if (Configs.Generic.ElytraAlarm.getBooleanValue()) {
                    if (this.sound == null) {
                        class_2960 location = class_2960.method_60655((String)"cubeside", (String)"alarm");
                        this.sound = class_3414.method_47908((class_2960)location);
                    }
                    if (mc.field_1724.method_6128() && mc.field_1724.method_23318() <= (double)mc.field_1687.method_31607()) {
                        if (this.soundThread == null) {
                            this.soundThread = SoundThread.of(1944L, this.sound, (class_1657)mc.field_1724);
                            this.soundThread.start();
                        }
                    } else if (this.soundThread != null && this.soundThread.isRunning()) {
                        this.soundThread.stopThread();
                        this.soundThread = null;
                    }
                }
                while (KeyBinds.AUTO_CHAT.method_1436()) {
                    if (PermissionHandler.hasPermission((String)"cubeside.autochat")) {
                        if (Configs.PermissionSettings.AutoChat.getBooleanValue()) {
                            Configs.PermissionSettings.AutoChat.setBooleanValue(false);
                            mc.field_1724.method_7353(class_2561.method_30163((String)"\u00a7cAuto Chat deaktiviert"), true);
                        } else {
                            Configs.PermissionSettings.AutoChat.setBooleanValue(true);
                            mc.field_1724.method_7353(class_2561.method_30163((String)"\u00a7aAuto Chat aktiviert"), true);
                        }
                        Configs.saveToFile();
                        continue;
                    }
                    ChatUtils.sendErrorMessage("AutoChat kannst du erst ab Staff benutzen!");
                }
                while (KeyBinds.TOGGLE_SHOW_ENTITIES_IN_SPECTATOR_MODE.method_1436()) {
                    if (Configs.Generic.ShowInvisibleEntitiesInSpectator.getBooleanValue()) {
                        Configs.Generic.ShowInvisibleEntitiesInSpectator.setBooleanValue(false);
                        mc.field_1724.method_7353(class_2561.method_30163((String)"\u00a7aUnsichtbare Entities werden jetzt im Spectator nicht mehr angezeigt!"), true);
                    } else {
                        Configs.Generic.ShowInvisibleEntitiesInSpectator.setBooleanValue(true);
                        mc.field_1724.method_7353(class_2561.method_30163((String)"\u00a7aUnsichtbare Entities werden jetzt im Spectator wieder angezeigt!"), true);
                    }
                    Configs.saveToFile();
                }
                while (KeyBinds.SET_MINING_ASSISTANT_START_POINT.method_1436()) {
                    MiningAssistent.setStartPos(class_310.method_1551().field_1724.method_24515());
                }
                while (KeyBinds.TOGGLE_MINING_ASSISTANT.method_1436()) {
                    Configs.MiningAssistent.MiningAssistentEnabled.setBooleanValue(!Configs.MiningAssistent.MiningAssistentEnabled.getBooleanValue());
                    Configs.saveToFile();
                    mc.field_1724.method_7353(class_2561.method_30163((String)("MiningAssistent set to: " + (Configs.MiningAssistent.MiningAssistentEnabled.getBooleanValue() ? "\u00a7atrue" : "\u00a7cfalse"))), true);
                }
                while (KeyBinds.WOOD_STRIPING.method_1436()) {
                    Configs.Generic.WoodStriping.setBooleanValue(!Configs.Generic.WoodStriping.getBooleanValue());
                    Configs.saveToFile();
                    mc.field_1724.method_7353(class_2561.method_30163((String)("WoodStriping set to: " + (Configs.Generic.WoodStriping.getBooleanValue() ? "\u00a7atrue" : "\u00a7cfalse"))), true);
                }
                while (KeyBinds.CREATE_GRASS_PATH.method_1436()) {
                    Configs.Generic.CreateGrassPath.setBooleanValue(!Configs.Generic.CreateGrassPath.getBooleanValue());
                    Configs.saveToFile();
                    mc.field_1724.method_7353(class_2561.method_30163((String)("CreateGrassPath set to: " + (Configs.Generic.CreateGrassPath.getBooleanValue() ? "\u00a7atrue" : "\u00a7cfalse"))), true);
                }
                while (KeyBinds.EDIT_SIGN.method_1436()) {
                    Configs.Generic.SignEdit.setBooleanValue(!Configs.Generic.SignEdit.getBooleanValue());
                    Configs.saveToFile();
                    mc.field_1724.method_7353(class_2561.method_30163((String)("SignEdit set to: " + (Configs.Generic.SignEdit.getBooleanValue() ? "\u00a7atrue" : "\u00a7cfalse"))), true);
                }
            }
            if (Configs.Chat.SaveMessagesToDatabase.getBooleanValue()) {
                LocalDate date = LocalDate.now();
                if (this.lastTickDate != null && !this.lastTickDate.isEqual(date)) {
                    ChatUtils.sendNormalMessage("Neuer Tag: " + date.format(DateTimeFormatter.ofPattern("dd.MM.yyyy")));
                }
                this.lastTickDate = date;
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> CubesideClientFabric.commands.register((CommandDispatcher<FabricClientCommandSource>)dispatcher));
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_1799 itemInHand = player.method_5998(hand);
            class_2338 blockPos = hitResult.method_17777();
            class_2680 blockState = world.method_8320(blockPos);
            if (!Configs.Generic.WoodStriping.getBooleanValue() && itemInHand.method_7909() instanceof class_1743 && class_1743.field_7898.containsKey(blockState.method_26204())) {
                return class_1269.field_5814;
            }
            if (!Configs.Generic.CreateGrassPath.getBooleanValue() && itemInHand.method_7909() instanceof class_1821 && class_1821.field_8912.containsKey(blockState.method_26204())) {
                return class_1269.field_5814;
            }
            if (!Configs.Generic.SignEdit.getBooleanValue() && blockState.method_26204() instanceof class_2478) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
    }

    public String getMapName(class_310 client) {
        Optional<class_1132> integratedServer = Optional.ofNullable(client.method_1576());
        if (integratedServer.isEmpty()) {
            String error = "Tried fetching map name on a non-integrated server!";
            CubesideClientFabric.LOGGER.fatal(error);
            throw new IllegalStateException(error);
        }
        return integratedServer.get().method_27050(class_5218.field_24188).normalize().toFile().getName();
    }

    public String getServerName(class_634 networkHandler) {
        Object serverName;
        block5: {
            serverName = null;
            try {
                boolean isRealm;
                class_642 serverInfo = networkHandler.method_45734();
                serverInfo = serverInfo != null ? serverInfo : class_310.method_1551().method_1558();
                boolean bl = isRealm = serverInfo != null && serverInfo.method_52811();
                if (serverInfo == null) break block5;
                boolean isOnLAN = serverInfo.method_2994();
                if (isOnLAN) {
                    CubesideClientFabric.LOGGER.warn("LAN server detected!");
                    serverName = serverInfo.field_3752;
                    break block5;
                }
                if (isRealm) {
                    CubesideClientFabric.LOGGER.info("Server is a Realm.");
                    class_4341 realmsClient = class_4341.method_20989((class_310)class_310.method_1551());
                    class_4879 realmsServerList = realmsClient.method_21015();
                    for (class_4877 realmsServer : realmsServerList.field_22622) {
                        if (!realmsServer.field_22601.equals(serverInfo.field_3752)) continue;
                        serverName = "Realm_" + realmsServer.field_22599 + "." + String.valueOf(realmsServer.field_22605);
                        break block5;
                    }
                    break block5;
                }
                serverName = serverInfo.field_3761;
            }
            catch (Exception var6) {
                CubesideClientFabric.LOGGER.error("error getting ServerData", (Throwable)var6);
            }
        }
        return serverName;
    }

    public static String scrubNameFile(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("<", "~less~").replace(">", "~greater~").replace(":", "~colon~").replace("\"", "~quote~").replace("/", "~slash~").replace("\\", "~backslash~").replace("|", "~pipe~").replace("?", "~question~").replace("*", "~star~");
    }
}

