/*
 * Decompiled with CFR 0.152.
 */
package de.fanta.cubeside;

import de.fanta.cubeside.config.Configs;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3726;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class MiningAssistent {
    private static class_2338 startPos;
    public static int count;

    public static void render(class_4587 stack) {
        if (startPos == null) {
            startPos = new class_2338(Configs.MiningAssistent.MiningAssistentStartX.getIntegerValue(), Configs.MiningAssistent.MiningAssistentStartY.getIntegerValue(), Configs.MiningAssistent.MiningAssistentStartZ.getIntegerValue());
        }
        if (Configs.MiningAssistent.MiningAssistentEnabled.getBooleanValue() && startPos != null) {
            MiningAssistent.spawnParticleSpiral(stack, Configs.MiningAssistent.MiningAssistentDistance.getIntegerValue(), Configs.MiningAssistent.MiningAssistentCircles.getIntegerValue());
        }
    }

    public static void spawnParticleSpiral(class_4587 stack, int distance, int circles) {
        Point current = new Point(startPos.method_10263(), startPos.method_10260());
        double radius = 0.0;
        for (int i = 0; i < circles; ++i) {
            MiningDirection dir = MiningDirection.NORTH;
            for (int j = 0; j < 4; ++j) {
                int k = 0;
                while ((double)k < radius) {
                    current = current.move(dir);
                    class_2338 loc = MiningAssistent.getNextY(new class_2338(current.x, startPos.method_10264(), current.z));
                    if ((double)k == radius - 1.0) {
                        if (dir == MiningDirection.WEST) {
                            MiningAssistent.renderTextOnBlock(stack, loc, dir, String.valueOf(i + 2), 16711875);
                        } else {
                            MiningAssistent.renderTextOnBlock(stack, loc, dir, dir.getCornerArrow(), 16407647);
                        }
                    } else {
                        MiningAssistent.renderTextOnBlock(stack, loc, dir, dir.getArrow(), 4587379);
                    }
                    ++k;
                }
                dir = dir.next();
                radius += 0.5 + (double)distance / 2.0;
            }
        }
    }

    private static class_2338 getNextY(class_2338 pos) {
        for (int y = pos.method_10264(); y <= pos.method_10264() + 5; ++y) {
            class_2338 currentLocation = new class_2338(pos.method_10263(), y, pos.method_10260());
            class_2680 state = class_310.method_1551().field_1687.method_8320(currentLocation);
            if (state == null || !state.method_26215()) continue;
            return new class_2338(pos.method_10263(), y, pos.method_10260());
        }
        return pos;
    }

    public static void setStartPos(class_2338 startPos) {
        MiningAssistent.startPos = startPos;
        Configs.MiningAssistent.MiningAssistentStartX.setIntegerValue(startPos.method_10263());
        Configs.MiningAssistent.MiningAssistentStartY.setIntegerValue(startPos.method_10264());
        Configs.MiningAssistent.MiningAssistentStartZ.setIntegerValue(startPos.method_10260());
        Configs.saveToFile();
    }

    public static void renderTextOnBlock(class_4587 matrixStack, class_2338 pos, MiningDirection direction, String string, int color) {
        class_2338 down = new class_2338(pos.method_10263(), pos.method_10264() - 1, pos.method_10260());
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_4597.class_4598 source = class_310.method_1551().method_22940().method_23000();
        class_638 world = class_310.method_1551().field_1687;
        String text = String.valueOf(string);
        class_327 font = class_310.method_1551().field_1772;
        double cameraX = camera.method_19326().field_1352;
        double cameraY = camera.method_19326().field_1351;
        class_265 upperOutlineShape = world.method_8320(down).method_26172((class_1922)world, down, class_3726.method_16195((class_1297)class_310.method_1551().field_1724));
        if (!upperOutlineShape.method_1110()) {
            cameraY += 1.0 - upperOutlineShape.method_1105(class_2350.class_2351.field_11052);
        }
        double cameraZ = camera.method_19326().field_1350;
        matrixStack.method_22903();
        matrixStack.method_22904((double)pos.method_10263() + 0.5 - cameraX, (double)pos.method_10264() - cameraY + 0.005, (double)pos.method_10260() + 0.5 - cameraZ);
        matrixStack.method_22907((Quaternionfc)new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, 90.0f));
        float size = 0.07f;
        matrixStack.method_22905(-size, -size, size);
        float float_3 = (float)(-font.method_1727(text)) / 2.0f + 0.4f;
        font.method_27521(text, float_3, -3.5f, color, false, matrixStack.method_23760().method_23761(), (class_4597)source, class_327.class_6415.field_33993, 0, 0xF000F0);
        matrixStack.method_22909();
    }

    static {
        count = 0;
    }

    public record Point(int x, int z) {
        public Point move(MiningDirection dir) {
            return new Point(this.x() + dir.xDiff, this.z() + dir.zDiff);
        }
    }

    public static enum MiningDirection {
        NORTH(0, 1),
        EAST(1, 0),
        SOUTH(0, -1),
        WEST(-1, 0);

        public final int xDiff;
        public final int zDiff;

        private MiningDirection(int xDiff, int zDiff) {
            this.xDiff = xDiff;
            this.zDiff = zDiff;
        }

        public MiningDirection next() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> EAST;
                case 1 -> SOUTH;
                case 2 -> WEST;
                case 3 -> NORTH;
            };
        }

        public String getArrow() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "\u2191";
                case 1 -> "\u2190";
                case 2 -> "\u2193";
                case 3 -> "\u2192";
            };
        }

        public String getCornerArrow() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "\u2190";
                case 1 -> "\u2193";
                case 2 -> "\u2192";
                case 3 -> "\u2191";
            };
        }
    }
}

