/*
 * Decompiled with CFR 0.152.
 */
package de.fanta.cubeside.config;

import com.google.common.collect.ImmutableList;
import de.fanta.cubeside.config.Configs;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Collections;
import java.util.List;

public class ConfigGui
extends GuiConfigsBase {
    private static ConfigGuiTab tab = ConfigGuiTab.GENERIC;

    public ConfigGui() {
        super(10, 50, "cubeside", null, "cubeside.gui.title.configs", new Object[0]);
    }

    public void initGui() {
        super.initGui();
        this.clearOptions();
        int x = 10;
        int y = 26;
        for (ConfigGuiTab tab : ConfigGuiTab.VALUES) {
            x += this.createButton(x, y, -1, tab);
        }
    }

    private int createButton(int x, int y, int width, ConfigGuiTab tab) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, tab.getDisplayName(), new String[0]);
        button.setEnabled(ConfigGui.tab != tab);
        this.addButton((ButtonBase)button, new ButtonListener(tab, this));
        return button.getWidth() + 2;
    }

    protected int getConfigWidth() {
        ConfigGuiTab tab = ConfigGui.tab;
        return super.getConfigWidth();
    }

    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        ImmutableList<IConfigBase> configs;
        ConfigGuiTab tab = ConfigGui.tab;
        if (tab == ConfigGuiTab.GENERIC) {
            configs = Configs.Generic.OPTIONS;
        } else if (tab == ConfigGuiTab.CHAT) {
            configs = Configs.Chat.OPTIONS;
        } else if (tab == ConfigGuiTab.CHUNKLOADING) {
            configs = Configs.ChunkLoading.OPTIONS;
        } else if (tab == ConfigGuiTab.FUN) {
            configs = Configs.Fun.OPTIONS;
        } else if (tab == ConfigGuiTab.HITBOX) {
            configs = Configs.HitBox.OPTIONS;
        } else if (tab == ConfigGuiTab.MININGASSISTENT) {
            configs = Configs.MiningAssistent.OPTIONS;
        } else if (tab == ConfigGuiTab.FIXES) {
            configs = Configs.Fixes.OPTIONS;
        } else if (tab == ConfigGuiTab.PERMISSIONSETTINGS) {
            configs = Configs.PermissionSettings.OPTIONS;
        } else {
            return Collections.emptyList();
        }
        return GuiConfigsBase.ConfigOptionWrapper.createFor(configs);
    }

    public void method_25432() {
        if (((WidgetListConfigOptions)this.getListWidget()).wereConfigsModified()) {
            ((WidgetListConfigOptions)this.getListWidget()).applyPendingModifications();
            this.onSettingsChanged();
            ((WidgetListConfigOptions)this.getListWidget()).clearConfigsModifiedFlag();
            Configs.saveToFile();
        }
        Configs.saveToFile();
    }

    public static enum ConfigGuiTab {
        GENERIC("cubeside.gui.button.config_gui.generic"),
        CHAT("cubeside.gui.button.config_gui.chat"),
        CHUNKLOADING("cubeside.gui.button.config_gui.chunkloading"),
        FUN("cubeside.gui.button.config_gui.fun"),
        HITBOX("cubeside.gui.button.config_gui.hitbox"),
        MININGASSISTENT("cubeside.gui.button.config_gui.miningassistent"),
        FIXES("cubeside.gui.button.config_gui.fixes"),
        PERMISSIONSETTINGS("cubeside.gui.button.config_gui.permissionsettings");

        private final String translationKey;
        public static final ImmutableList<ConfigGuiTab> VALUES;

        private ConfigGuiTab(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getDisplayName() {
            return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])ConfigGuiTab.values());
        }
    }

    private static class ButtonListener
    implements IButtonActionListener {
        private final ConfigGui parent;
        private final ConfigGuiTab tab;

        public ButtonListener(ConfigGuiTab tab, ConfigGui parent) {
            this.tab = tab;
            this.parent = parent;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            tab = this.tab;
            this.parent.reCreateListWidget();
            ((WidgetListConfigOptions)this.parent.getListWidget()).resetScrollbarPosition();
            this.parent.initGui();
        }
    }
}

