/*
 * Decompiled with CFR 0.152.
 */
package de.fanta.cubeside.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.fanta.cubeside.CubesideClientFabric;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.config.options.ConfigColorList;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigString;
import fi.dy.masa.malilib.config.options.ConfigStringList;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import java.io.File;
import java.io.IOException;
import net.minecraft.class_2561;
import org.apache.commons.io.FileUtils;

public class Configs
implements IConfigHandler {
    private static final String CONFIG_FILE_NAME = "cubeside.json";
    private static final int CONFIG_VERSION = 1;

    public static void loadFromFile() {
        JsonElement element;
        File oldConfigFile = new File(fi.dy.masa.malilib.util.FileUtils.getConfigDirectoryAsPath().toFile(), CONFIG_FILE_NAME);
        File configFile = new File(CubesideClientFabric.getConfigDirectory(), CONFIG_FILE_NAME);
        if (oldConfigFile.exists()) {
            try {
                FileUtils.moveFile((File)oldConfigFile, (File)configFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!configFile.exists()) {
            Configs.saveToFile();
        }
        if (configFile.exists() && configFile.isFile() && configFile.canRead() && (element = JsonUtils.parseJsonFile((File)configFile)) != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            ConfigUtils.readConfigBase((JsonObject)root, (String)"Generic", Generic.OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"Chat", Chat.OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"ChunkLoading", ChunkLoading.OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"Fun", Fun.OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"Hitbox", HitBox.OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"Hitbox", HitBox.INVISIBLE_OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"MiningAssistent", MiningAssistent.OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"MiningAssistent", MiningAssistent.INVISIBLE_OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"Fixes", Fixes.OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"PermissionSettings", PermissionSettings.OPTIONS);
        }
    }

    public static void saveToFile() {
        File dir = CubesideClientFabric.getConfigDirectory();
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            JsonObject root = new JsonObject();
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Generic", Generic.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Chat", Chat.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"ChunkLoading", ChunkLoading.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Fun", Fun.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Hitbox", HitBox.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Hitbox", HitBox.INVISIBLE_OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"MiningAssistent", MiningAssistent.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"MiningAssistent", MiningAssistent.INVISIBLE_OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Fixes", Fixes.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"PermissionSettings", PermissionSettings.OPTIONS);
            root.add("config_version", (JsonElement)new JsonPrimitive((Number)1));
            JsonUtils.writeJsonToFile((JsonObject)root, (File)new File(dir, CONFIG_FILE_NAME));
            CubesideClientFabric.LOGGER.info("[CubesideMod] Config Saved");
        }
    }

    public void load() {
        Configs.loadFromFile();
    }

    public void save() {
        Configs.saveToFile();
    }

    public static class Generic {
        public static final ConfigBoolean ThirdPersonElytra = new ConfigBoolean("ThirdPersonElytra", false, class_2561.method_43471((String)"options.cubeside.thirdpersonelytra").getString());
        public static final ConfigBoolean ElytraAlarm = new ConfigBoolean("ElytraAlarm", false, class_2561.method_43471((String)"options.cubeside.elytraalarm").getString());
        public static final ConfigBoolean ShowInvisibleArmorstands = new ConfigBoolean("ShowInvisibleArmorstands", true, class_2561.method_43471((String)"options.cubeside.showinvisiblearmorstands").getString());
        public static final ConfigBoolean ShowInvisibleEntitiesInSpectator = new ConfigBoolean("ShowInvisibleEntitiesInSpectator", true, class_2561.method_43471((String)"options.cubeside.showinvisibleentitiesinspectator").getString());
        public static final ConfigBoolean AFKPling = new ConfigBoolean("AFKPling", false, class_2561.method_43471((String)"options.cubeside.afkpling").getString());
        public static final ConfigBoolean ClickableTpaMessage = new ConfigBoolean("ClickableTpaMessage", true, class_2561.method_43471((String)"options.cubeside.clickabletpamessage").getString());
        public static final ConfigBoolean TpaSound = new ConfigBoolean("TpaSound", true, class_2561.method_43471((String)"options.cubeside.tpasound").getString());
        public static final ConfigBoolean GamemodeSwitcher = new ConfigBoolean("GamemodeSwitcher", true, class_2561.method_43471((String)"options.cubeside.gamemodeswitcher").getString());
        public static final ConfigBoolean ActionBarShadow = new ConfigBoolean("ActionBarShadow", true, class_2561.method_43471((String)"options.cubeside.actionbarshadow").getString());
        public static final ConfigBoolean WoodStriping = new ConfigBoolean("WoodStriping", true, class_2561.method_43471((String)"options.cubeside.woodstriping").getString());
        public static final ConfigBoolean CreateGrassPath = new ConfigBoolean("CreateGrassPath", true, class_2561.method_43471((String)"options.cubeside.creategrasspath").getString());
        public static final ConfigBoolean SignEdit = new ConfigBoolean("SingEdit", true, class_2561.method_43471((String)"options.cubeside.singedit").getString());
        public static final ConfigBoolean ShowAdditionalRepairCosts = new ConfigBoolean("ShowAdditionalRepairCosts", false, class_2561.method_43471((String)"options.cubeside.showadditionalrepaircosts").getString());
        public static final ConfigString FastJoinButtonText = new ConfigString("FastJoinButtonText", "Join Cubeside", class_2561.method_43471((String)"options.cubeside.fastjoinbuttontext").getString());
        public static final ConfigString FastJoinButtonIP = new ConfigString("FastJoinButtonIP", "cubeside.de", class_2561.method_43471((String)"options.cubeside.fastjoinbuttonip").getString());
        public static final ConfigInteger FastJoinButtonPort = new ConfigInteger("FastJoinButtonPort", 25565, class_2561.method_43471((String)"options.cubeside.fastjoinbuttonport").getString());
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)ThirdPersonElytra, (Object)ElytraAlarm, (Object)ShowInvisibleArmorstands, (Object)ShowInvisibleEntitiesInSpectator, (Object)AFKPling, (Object)ClickableTpaMessage, (Object)TpaSound, (Object)GamemodeSwitcher, (Object)ActionBarShadow, (Object)WoodStriping, (Object)CreateGrassPath, (Object)SignEdit, (Object[])new IConfigBase[]{ShowAdditionalRepairCosts, FastJoinButtonText, FastJoinButtonIP, FastJoinButtonPort});
    }

    public static class Chat {
        public static final ConfigBoolean ChatTimeStamps = new ConfigBoolean("ChatTimeStamps", false, class_2561.method_43471((String)"options.cubeside.chattimestamps").getString());
        public static final ConfigColor TimeStampColor = new ConfigColor("TimeStampColor", "#ffffff", class_2561.method_43471((String)"options.cubeside.timestampcolor").getString());
        public static final ConfigBoolean SaveMessagesToDatabase = new ConfigBoolean("SaveMessagesToDatabase", false, class_2561.method_43471((String)"options.cubeside.savemessagestodatabase").getString());
        public static final ConfigInteger DaysTheMessagesAreStored = new ConfigInteger("DaysTheMessagesAreStored", 10, 1, 30, true, class_2561.method_43471((String)"options.cubeside.daysthemessagesarestored").getString());
        public static final ConfigInteger ChatMessageLimit = new ConfigInteger("ChatMessageLimit", 100, 1, 100000, true, class_2561.method_43471((String)"options.cubeside.chatlimit").getString());
        public static final ConfigBoolean DisplayChatInfo = new ConfigBoolean("DisplayChatInfo", true, class_2561.method_43471((String)"options.cubeside.displaychatinfo").getString());
        public static final ConfigBoolean CountDuplicateMessages = new ConfigBoolean("CountDuplicateMessages", false, class_2561.method_43471((String)"options.cubeside.countduplicatemessages").getString());
        public static final ConfigString CountDuplicateMessagesFormat = new ConfigString("CountDuplicateMessagesFormat", " (%sx)", class_2561.method_43471((String)"options.cubeside.countduplicatemessagesformat").getString());
        public static final ConfigColor CountDuplicateMessagesColor = new ConfigColor("CountDuplicateMessagesColor", "#ffffff", class_2561.method_43471((String)"options.cubeside.countduplicatemessagescolor").getString());
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)ChatTimeStamps, (Object)TimeStampColor, (Object)SaveMessagesToDatabase, (Object)DaysTheMessagesAreStored, (Object)ChatMessageLimit, (Object)DisplayChatInfo, (Object)CountDuplicateMessages, (Object)CountDuplicateMessagesFormat, (Object)CountDuplicateMessagesColor);
    }

    public static class ChunkLoading {
        public static final ConfigBoolean FullVerticalView = new ConfigBoolean("FullVerticalView", true, class_2561.method_43471((String)"options.cubeside.fullverticalview").getString());
        public static final ConfigBoolean UnloadChunks = new ConfigBoolean("UnloadChunks", true, class_2561.method_43471((String)"options.cubeside.unloadchunks").getString());
        public static final ConfigInteger FakeViewDistance = new ConfigInteger("FakeViewDistance", 32, 1, 64, true, class_2561.method_43471((String)"options.cubeside.fakeviewdistance").getString());
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)FullVerticalView, (Object)UnloadChunks, (Object)FakeViewDistance);
    }

    public static class Fun {
        public static final ConfigBoolean DisableChristmasChest = new ConfigBoolean("DisableChristmasChest", false, class_2561.method_43471((String)"options.cubeside.removechristmaschest").getString());
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)DisableChristmasChest);
    }

    public static class HitBox {
        public static final ConfigBoolean KeepEntityHitBox = new ConfigBoolean("KeepEntityHitBox", false, class_2561.method_43471((String)"options.cubeside.keepentityhitbox").getString());
        public static final ConfigBoolean RainbowEntityHitBox = new ConfigBoolean("RainbowEntityHitBox", false, class_2561.method_43471((String)"options.cubeside.rainbowentityhitbox").getString());
        public static final ConfigColorList RainbowEntityHitBoxColorList = new ConfigColorList("RainbowEntityHitBoxColorList", ImmutableList.of((Object)Color4f.fromColor((int)0xFF0004), (Object)Color4f.fromColor((int)16754176), (Object)Color4f.fromColor((int)16769280), (Object)Color4f.fromColor((int)65305), (Object)Color4f.fromColor((int)35071), (Object)Color4f.fromColor((int)13959423)), class_2561.method_43471((String)"options.cubeside.rainbowentityhitboxcolorlist").getString());
        public static final ConfigDouble RainbowEntityHitBoxSpeed = new ConfigDouble("RainbowEntityHitBoxSpeed", 0.1, 0.0, 1.0, true, class_2561.method_43471((String)"options.cubeside.rainbowentityhitboxspeed").getString());
        public static final ConfigDouble EntityHitBoxVisibility = new ConfigDouble("EntityHitBoxVisibility", 1.0, 0.0, 1.0, true, class_2561.method_43471((String)"options.cubeside.entityhitboxvisibility").getString());
        public static final ConfigColor EntityHitBoxColor = new ConfigColor("EntityHitBoxColor", "#ffffff", class_2561.method_43471((String)"options.cubeside.entityhitboxcolor").getString());
        public static final ConfigBoolean EntityHitBoxDirection = new ConfigBoolean("EntityHitBoxDirection", true, class_2561.method_43471((String)"options.cubeside.entityhitboxdirection").getString());
        public static final ConfigBoolean RainbowBlockHitBox = new ConfigBoolean("RainbowBlockHitBox", false, class_2561.method_43471((String)"options.cubeside.rainbowblockhitbox").getString());
        public static final ConfigColorList RainbowBlockHitBoxColorList = new ConfigColorList("RainbowBlockHitBoxColorList", ImmutableList.of((Object)Color4f.fromColor((int)0xFF0004), (Object)Color4f.fromColor((int)16754176), (Object)Color4f.fromColor((int)16769280), (Object)Color4f.fromColor((int)65305), (Object)Color4f.fromColor((int)35071), (Object)Color4f.fromColor((int)13959423)), class_2561.method_43471((String)"options.cubeside.rainbowblockhitboxcolorlist").getString());
        public static final ConfigDouble RainbowBlockHitBoxSpeed = new ConfigDouble("RainbowBlockHitBoxSpeed", 0.1, 0.0, 1.0, true, class_2561.method_43471((String)"options.cubeside.rainbowblockhitboxspeed").getString());
        public static final ConfigDouble BlockHitBoxVisibility = new ConfigDouble("BlockHitBoxVisibility", 0.4, 0.0, 1.0, true, class_2561.method_43471((String)"options.cubeside.blockhitboxvisibility").getString());
        public static final ConfigColor BlockHitBoxColor = new ConfigColor("BlockHitBoxColor", "#000000", class_2561.method_43471((String)"options.cubeside.blockhitboxcolor").getString());
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)KeepEntityHitBox, (Object)RainbowEntityHitBox, (Object)RainbowEntityHitBoxColorList, (Object)RainbowEntityHitBoxSpeed, (Object)EntityHitBoxColor, (Object)EntityHitBoxVisibility, (Object)EntityHitBoxDirection, (Object)RainbowBlockHitBox, (Object)RainbowBlockHitBoxColorList, (Object)RainbowBlockHitBoxSpeed, (Object)BlockHitBoxColor, (Object)BlockHitBoxVisibility, (Object[])new IConfigBase[0]);
        public static final ConfigBoolean ShowHitBox = new ConfigBoolean("ShowHitBox", false, class_2561.method_43471((String)"options.cubeside.showhitbox").getString());
        public static final ImmutableList<IConfigBase> INVISIBLE_OPTIONS = ImmutableList.of((Object)ShowHitBox);
    }

    public static class MiningAssistent {
        public static final ConfigBoolean MiningAssistentEnabled = new ConfigBoolean("MiningAssistentEnabled", false, class_2561.method_43471((String)"options.cubeside.miningassistentenabled").getString());
        public static final ConfigInteger MiningAssistentDistance = new ConfigInteger("MiningAssistentDistance", 3, 0, 10, class_2561.method_43471((String)"options.cubeside.miningassistentdistance").getString());
        public static final ConfigInteger MiningAssistentCircles = new ConfigInteger("MiningAssistentCircles", 16, 1, 30, class_2561.method_43471((String)"options.cubeside.miningassistentcircles").getString());
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)MiningAssistentEnabled, (Object)MiningAssistentDistance, (Object)MiningAssistentCircles);
        public static final ConfigInteger MiningAssistentStartX = new ConfigInteger("MiningAssistentStartX", 0, class_2561.method_43471((String)"options.cubeside.miningassistentstartx").getString());
        public static final ConfigInteger MiningAssistentStartY = new ConfigInteger("MiningAssistentStartY", 0, class_2561.method_43471((String)"options.cubeside.miningassistentstarty").getString());
        public static final ConfigInteger MiningAssistentStartZ = new ConfigInteger("MiningAssistentStartZ", 0, class_2561.method_43471((String)"options.cubeside.miningassistentstartz").getString());
        public static final ImmutableList<IConfigBase> INVISIBLE_OPTIONS = ImmutableList.of((Object)MiningAssistentStartX, (Object)MiningAssistentStartY, (Object)MiningAssistentStartZ);
    }

    public static class Fixes {
        public static final ConfigBoolean SimpleSignGlow = new ConfigBoolean("SimpleSignGlow", false, class_2561.method_43471((String)"options.cubeside.simplesignglow").getString());
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)SimpleSignGlow);
    }

    public static class PermissionSettings {
        public static final ConfigBoolean AutoChat = new ConfigBoolean("AutoChat", false, "AutoChat Enabled");
        public static final ConfigString AutoChatAntwort = new ConfigString("AutoChatAntwort", "Ich habe grade leider keine Zeit!", "AutoChat Message");
        public static final ConfigStringList AdminList = new ConfigStringList("AdminList", ImmutableList.of((Object)"Eiki", (Object)"Brokkonaut", (Object)"jonibohni", (Object)"_Scorcho", (Object)"Starjon", (Object)"Becky0810", (Object)"Scoptixxx"), "Admin Liste");
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)AutoChat, (Object)AutoChatAntwort, (Object)AdminList);
    }
}

