/*
 * Decompiled with CFR 0.152.
 */
package de.fanta.cubeside.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.fanta.cubeside.CubesideClientFabric;
import de.fanta.cubeside.config.Configs;
import de.fanta.cubeside.data.ChatMessage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11341;
import net.minecraft.class_2561;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_8824;
import org.apache.logging.log4j.Level;

public class ChatDatabase {
    private final String server;
    private final class_5455 registry;
    private File dbFile;
    private ArrayList<ChatMessage> chatMessages;
    private ArrayList<ChatMessage> commands;
    private boolean markNextMessageDeleted;
    private DataOutputStream dataOut;

    public ChatDatabase(String server, class_5455 registry) {
        long time = System.nanoTime();
        this.server = server;
        this.registry = registry;
        this.chatMessages = new ArrayList();
        this.commands = new ArrayList();
        long minTime = System.currentTimeMillis() - (long)Configs.Chat.DaysTheMessagesAreStored.getIntegerValue() * 24L * 60L * 60L * 1000L;
        this.dbFile = new File(CubesideClientFabric.getConfigDirectory(), "/chatStorage/" + server.toLowerCase() + ".dat");
        if (this.dbFile.isFile()) {
            try {
                DataInputStream dataIn = new DataInputStream(new BufferedInputStream(new FileInputStream(this.dbFile)));
                try {
                    while (true) {
                        long msgtime;
                        String msg;
                        byte type;
                        if ((type = dataIn.readByte()) == 0) {
                            if (dataIn.readBoolean() && !this.chatMessages.isEmpty()) {
                                this.chatMessages.removeLast();
                            }
                            msg = dataIn.readUTF();
                            msgtime = dataIn.readLong();
                            if (msgtime < minTime) continue;
                            this.chatMessages.addLast(new ChatMessage(msg, msgtime));
                            continue;
                        }
                        if (type != 1) continue;
                        msg = dataIn.readUTF();
                        msgtime = dataIn.readLong();
                        if (msgtime < minTime) continue;
                        this.commands.addLast(new ChatMessage(msg, msgtime));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        dataIn.close();
                    }
                    catch (Throwable msg) {
                        throwable.addSuppressed(msg);
                    }
                    throw throwable;
                }
            }
            catch (EOFException dataIn) {
            }
            catch (IOException e) {
                CubesideClientFabric.LOGGER.log(Level.ERROR, "Could not load chat messages", (Throwable)e);
                this.dbFile = null;
            }
        }
        long delta = System.nanoTime() - time;
        CubesideClientFabric.LOGGER.info("Loaded " + this.chatMessages.size() + " + " + this.commands.size() + " chatmessages for " + server + " in " + delta / 1000L + " micros");
        File oldDbFile = new File(CubesideClientFabric.getConfigDirectory(), "/chatStorage/" + server.toLowerCase() + "_1_.db");
        if (oldDbFile.isFile()) {
            oldDbFile.delete();
        }
        time = System.nanoTime();
        if (this.dbFile != null) {
            try {
                this.dataOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.dbFile)));
                for (ChatMessage message : this.chatMessages) {
                    this.writeChatMessage(message.text(), message.date(), false);
                }
                for (ChatMessage message : this.commands) {
                    this.writeCommand(message.text(), message.date(), false);
                }
                this.dataOut.flush();
            }
            catch (IOException e) {
                CubesideClientFabric.LOGGER.log(Level.ERROR, "Could not open chat messages file for writing", (Throwable)e);
            }
        }
        delta = System.nanoTime() - time;
        CubesideClientFabric.LOGGER.info("Saved " + this.chatMessages.size() + " + " + this.commands.size() + " chatmessages for " + server + " in " + delta / 1000L + " micros");
    }

    public void addMessageEntry(String message) {
        long now = System.currentTimeMillis();
        this.chatMessages.addLast(new ChatMessage(message, now));
        this.writeChatMessage(message, now, true);
    }

    private void writeChatMessage(String message, long now, boolean flush) {
        if (this.dbFile != null) {
            try {
                this.dataOut.writeByte(0);
                this.dataOut.writeBoolean(this.markNextMessageDeleted);
                try {
                    this.dataOut.writeUTF(message);
                }
                catch (UTFDataFormatException e) {
                    this.dataOut.writeUTF("");
                }
                this.dataOut.writeLong(now);
                if (flush) {
                    this.dataOut.flush();
                }
            }
            catch (IOException e) {
                CubesideClientFabric.LOGGER.log(Level.ERROR, "Could not serialize chat message", (Throwable)e);
            }
            this.markNextMessageDeleted = false;
        }
    }

    public void addCommandEntry(String command) {
        long now = System.currentTimeMillis();
        this.commands.add(new ChatMessage(command, now));
        this.writeCommand(command, now, true);
    }

    private void writeCommand(String command, long now, boolean flush) {
        if (this.dbFile != null) {
            try {
                this.dataOut.writeByte(1);
                try {
                    this.dataOut.writeUTF(command);
                }
                catch (UTFDataFormatException e) {
                    this.dataOut.writeUTF("");
                }
                this.dataOut.writeLong(now);
                if (flush) {
                    this.dataOut.flush();
                }
            }
            catch (IOException e) {
                CubesideClientFabric.LOGGER.log(Level.ERROR, "Could not serialize command", (Throwable)e);
            }
        }
    }

    public void close() {
        if (this.dataOut != null) {
            try {
                this.dataOut.close();
            }
            catch (IOException e) {
                CubesideClientFabric.LOGGER.log(Level.ERROR, "Could not close chat messages file", (Throwable)e);
            }
        }
    }

    public List<class_2561> loadMessages() {
        return this.loadMessages(-1);
    }

    public List<class_2561> loadMessages(int limit) {
        long time = System.nanoTime();
        ArrayList<class_2561> entries = new ArrayList<class_2561>();
        int size = this.chatMessages.size();
        int num = 0;
        class_6903 ops = this.registry.method_57093((DynamicOps)JsonOps.INSTANCE);
        for (ChatMessage entry : this.chatMessages) {
            if (limit == -1 || num >= size - limit) {
                try {
                    JsonElement jsonElement = class_11341.method_71360((String)entry.text());
                    DataResult result = class_8824.field_46597.decode((DynamicOps)ops, (Object)jsonElement);
                    if (result.isSuccess()) {
                        entries.add((class_2561)((Pair)result.getOrThrow()).getFirst());
                    }
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
            }
            ++num;
        }
        long delta = System.nanoTime() - time;
        CubesideClientFabric.LOGGER.info(entries.size() + " messages were loaded in " + delta / 1000L + " micros");
        return entries;
    }

    public List<String> loadCommands() {
        long time = System.nanoTime();
        ArrayList<String> entries = new ArrayList<String>();
        for (ChatMessage entry : this.commands) {
            entries.add(entry.text());
        }
        long delta = System.nanoTime() - time;
        CubesideClientFabric.LOGGER.info(entries.size() + " commands were loaded in " + delta / 1000L + " micros");
        return entries;
    }

    public void deleteNewestMessage() {
        this.markNextMessageDeleted = true;
        if (!this.chatMessages.isEmpty()) {
            this.chatMessages.removeLast();
        }
    }

    public String getServer() {
        return this.server;
    }
}

