/*
 * Decompiled with CFR 0.152.
 */
package de.fanta.cubeside.util;

import fi.dy.masa.malilib.util.data.Color4f;
import java.awt.Color;
import java.util.List;

public class ColorUtils {
    private ColorUtils() {
    }

    public static Color getColorGradient(long time, double speed, List<Color4f> baseColors) {
        double hue2;
        double cmin2;
        double hue1;
        double cmin1;
        int colorCount = baseColors.size();
        int v = Math.floorMod((int)((double)time * speed * 21.0), colorCount * 100);
        int step = v / 100;
        double ratio = (double)(v % 100) * 0.01;
        int c0 = baseColors.get((int)step).intValue;
        int c1 = baseColors.get((int)((step + 1) % baseColors.size())).intValue;
        int r1 = c0 >> 16 & 0xFF;
        int g1 = c0 >> 8 & 0xFF;
        int b1 = c0 & 0xFF;
        int r2 = c1 >> 16 & 0xFF;
        int g2 = c1 >> 8 & 0xFF;
        int b2 = c1 & 0xFF;
        double cmax1 = Math.max(r1, g1);
        if ((double)b1 > cmax1) {
            cmax1 = b1;
        }
        if ((double)b1 < (cmin1 = (double)Math.min(r1, g1))) {
            cmin1 = b1;
        }
        double brightness1 = cmax1 / 255.0;
        double saturation1 = cmax1 != 0.0 ? (cmax1 - cmin1) / cmax1 : 0.0;
        if (saturation1 == 0.0) {
            hue1 = 0.0;
        } else {
            double redc = (cmax1 - (double)r1) / (cmax1 - cmin1);
            double greenc = (cmax1 - (double)g1) / (cmax1 - cmin1);
            double bluec = (cmax1 - (double)b1) / (cmax1 - cmin1);
            hue1 = (double)r1 == cmax1 ? bluec - greenc : ((double)g1 == cmax1 ? 2.0 + redc - bluec : 4.0 + greenc - redc);
            if ((hue1 /= 6.0) < 0.0) {
                hue1 += 1.0;
            }
        }
        double cmax2 = Math.max(r2, g2);
        if ((double)b2 > cmax2) {
            cmax2 = b2;
        }
        if ((double)b2 < (cmin2 = (double)Math.min(r2, g2))) {
            cmin2 = b2;
        }
        double brightness2 = cmax2 / 255.0;
        double saturation2 = cmax2 != 0.0 ? (cmax2 - cmin2) / cmax2 : 0.0;
        if (saturation2 == 0.0) {
            hue2 = 0.0;
        } else {
            double redc = (cmax2 - (double)r2) / (cmax2 - cmin2);
            double greenc = (cmax2 - (double)g2) / (cmax2 - cmin2);
            double bluec = (cmax2 - (double)b2) / (cmax2 - cmin2);
            hue2 = (double)r2 == cmax2 ? bluec - greenc : ((double)g2 == cmax2 ? 2.0 + redc - bluec : 4.0 + greenc - redc);
            if ((hue2 /= 6.0) < 0.0) {
                hue2 += 1.0;
            }
        }
        double ratio2 = 1.0 - ratio;
        double brightness = brightness1 * ratio2 + brightness2 * ratio;
        double saturation = saturation1 * ratio2 + saturation2 * ratio;
        if (hue2 - hue1 > 0.5) {
            hue1 += 1.0;
        } else if (hue1 - hue2 > 0.5) {
            hue2 += 1.0;
        }
        double hue = hue1 * ratio2 + hue2 * ratio;
        if (hue > 1.0) {
            hue -= 1.0;
        }
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        if (saturation == 0.0) {
            g = b = (double)((int)(brightness * 255.0 + 0.5));
            r = b;
        } else {
            double h = (hue - Math.floor(hue)) * 6.0;
            double f = h - Math.floor(h);
            double p = brightness * (1.0 - saturation);
            double q = brightness * (1.0 - saturation * f);
            double t = brightness * (1.0 - saturation * (1.0 - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0 + 0.5);
                    g = (int)(t * 255.0 + 0.5);
                    b = (int)(p * 255.0 + 0.5);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0 + 0.5);
                    g = (int)(brightness * 255.0 + 0.5);
                    b = (int)(p * 255.0 + 0.5);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0 + 0.5);
                    g = (int)(brightness * 255.0 + 0.5);
                    b = (int)(t * 255.0 + 0.5);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0 + 0.5);
                    g = (int)(q * 255.0 + 0.5);
                    b = (int)(brightness * 255.0 + 0.5);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0 + 0.5);
                    g = (int)(p * 255.0 + 0.5);
                    b = (int)(brightness * 255.0 + 0.5);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0 + 0.5);
                    g = (int)(p * 255.0 + 0.5);
                    b = (int)(q * 255.0 + 0.5);
                }
            }
        }
        int rFinal = (int)r;
        int gFinal = (int)g;
        int bFinal = (int)b;
        int c = rFinal << 16 | gFinal << 8 | bFinal;
        return new Color(c);
    }
}

